/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.genericPredicates;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.genericPredicates.IPredicateQuery;

class QueryConjunction
implements IPredicateQuery {
    IPredicateQuery[] queries;

    public QueryConjunction(IPredicateQuery[] queries) {
        this.queries = queries;
    }

    @Override
    public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
        Continuation ret = null;
        int queryId = 0;
        while (queryId < this.queries.length) {
            Object continuation = this.queries[queryId].query(g, bindings);
            if (continuation == FAILURE) {
                while (true) {
                    if (ret == null) {
                        return FAILURE;
                    }
                    queryId = ret.instructionId;
                    continuation = this.queries[queryId].next(g, bindings, ret.continuation);
                    if (continuation != FAILURE) break;
                    ret = ret.next;
                }
                if (continuation == null) {
                    ret = ret.next;
                } else {
                    ret.continuation = continuation;
                }
            } else if (continuation != null) {
                ret = new Continuation(continuation, queryId, ret);
            }
            ++queryId;
        }
        return ret;
    }

    @Override
    public Object next(ReadGraph g, Object[] bindings, Object ret_) throws DatabaseException {
        Object continuation;
        int queryId;
        Continuation ret = (Continuation)ret_;
        while (true) {
            if (ret == null) {
                return FAILURE;
            }
            queryId = ret.instructionId;
            continuation = this.queries[queryId].next(g, bindings, ret.continuation);
            if (continuation != FAILURE) break;
            ret = ret.next;
        }
        if (continuation == null) {
            ret = ret.next;
        } else {
            ret.continuation = continuation;
        }
        ++queryId;
        while (queryId < this.queries.length) {
            continuation = this.queries[queryId].query(g, bindings);
            if (continuation == FAILURE) {
                while (true) {
                    if (ret == null) {
                        return FAILURE;
                    }
                    queryId = ret.instructionId;
                    continuation = this.queries[queryId].next(g, bindings, ret.continuation);
                    if (continuation != FAILURE) break;
                    ret = ret.next;
                }
                if (continuation == null) {
                    ret = ret.next;
                } else {
                    ret.continuation = continuation;
                }
            } else if (continuation != null) {
                ret = new Continuation(continuation, queryId, ret);
            }
            ++queryId;
        }
        return ret;
    }

    static class Continuation {
        Object continuation;
        int instructionId;
        Continuation next;

        public Continuation(Object continuation, int instructionId, Continuation next) {
            this.continuation = continuation;
            this.instructionId = instructionId;
            this.next = next;
        }
    }
}

