/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.genericPredicates;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.genericPredicates.BinaryPredicateAdapter;
import org.simantics.layer0.utils.genericPredicates.IBinaryPredicate2;
import org.simantics.layer0.utils.genericPredicates.IPredicate;
import org.simantics.layer0.utils.genericPredicates.IPredicateQuery;
import org.simantics.layer0.utils.genericPredicates.IQueryProcedure;
import org.simantics.layer0.utils.genericPredicates.IUnaryPredicate2;
import org.simantics.layer0.utils.genericPredicates.UnaryPredicateAdapter;

public class PredicateUtils {
    public static void forEach(ReadGraph g, Object[] bindings, IPredicateQuery query, IQueryProcedure proc) throws DatabaseException {
        Object cont = query.query(g, bindings);
        while (cont != IPredicateQuery.FAILURE && !proc.exec(bindings) && cont != null) {
            cont = query.next(g, bindings, cont);
        }
    }

    public static IUnaryPredicate2 toUnaryPredicate(IPredicate predicate) {
        if (predicate instanceof IUnaryPredicate2) {
            return (IUnaryPredicate2)predicate;
        }
        if (predicate.arity() == 1) {
            return new UnaryPredicateAdapter(predicate);
        }
        return null;
    }

    public static IBinaryPredicate2 toBinaryPredicate(IPredicate predicate) {
        if (predicate instanceof IBinaryPredicate2) {
            return (IBinaryPredicate2)predicate;
        }
        if (predicate.arity() == 2) {
            return new BinaryPredicateAdapter(predicate);
        }
        return null;
    }
}

