/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.genericPredicates;

import org.simantics.layer0.utils.genericPredicates.IPredicate;
import org.simantics.layer0.utils.genericPredicates.IPredicateQuery;
import org.simantics.layer0.utils.genericPredicates.IRule;
import org.simantics.layer0.utils.genericPredicates.QueryConjunction;
import org.simantics.layer0.utils.genericPredicates.RuleConjunction;

public class NaturalConjunction
implements IPredicate {
    IPredicate[] predicates;

    public NaturalConjunction(IPredicate[] predicates) {
        this.predicates = predicates;
    }

    @Override
    public int arity() {
        return this.predicates[0].arity();
    }

    @Override
    public IRule claim(int[] variables) {
        IRule[] rules = new IRule[this.predicates.length];
        int i = 0;
        while (i < rules.length) {
            rules[i] = this.predicates[i].claim(variables);
            ++i;
        }
        return new RuleConjunction(rules);
    }

    @Override
    public IRule deny(int[] variables) {
        IRule[] rules = new IRule[this.predicates.length];
        int i = 0;
        while (i < rules.length) {
            rules[i] = this.predicates[i].deny(variables);
            ++i;
        }
        return new RuleConjunction(rules);
    }

    @Override
    public IPredicateQuery query(int[] variables, int boundVariables) {
        IPredicateQuery[] queries = new IPredicateQuery[this.predicates.length];
        int k = 0;
        while (k < queries.length) {
            queries[0] = this.predicates[k].query(variables, boundVariables);
            if (queries[0] != null) break;
            ++k;
        }
        boundVariables = (1 << variables.length) - 1;
        int i = 0;
        int j = 1;
        while (i < queries.length) {
            if (i != k) {
                queries[j++] = this.predicates[i].query(variables, boundVariables);
            }
            ++i;
        }
        return new QueryConjunction(queries);
    }
}

