/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.genericPredicates;

import gnu.trove.TObjectIntHashMap;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.genericPredicates.IContextualModification;
import org.simantics.layer0.utils.genericPredicates.IPredicate;
import org.simantics.layer0.utils.genericPredicates.IPredicateBody;
import org.simantics.layer0.utils.genericPredicates.IPredicateQuery;
import org.simantics.layer0.utils.genericPredicates.IRule;

public class DefinedPredicate
implements IPredicate {
    Object[] variables;
    IPredicateBody body;

    public DefinedPredicate(Object[] variables, IPredicateBody body) {
        this.variables = variables;
        this.body = body;
    }

    @Override
    public int arity() {
        return this.variables.length;
    }

    @Override
    public IRule claim(int[] var) {
        TObjectIntHashMap variableMap = new TObjectIntHashMap();
        int i = 0;
        while (i < var.length) {
            variableMap.put(this.variables[i], i);
            ++i;
        }
        for (Object v : this.body.variables()) {
            if (variableMap.containsKey(v)) continue;
            variableMap.put(v, i++);
        }
        return new EncapsulatedRule(this.body.claim((TObjectIntHashMap<Object>)variableMap), var, i);
    }

    @Override
    public IRule deny(int[] var) {
        TObjectIntHashMap variableMap = new TObjectIntHashMap();
        int i = 0;
        while (i < var.length) {
            variableMap.put(this.variables[i], i);
            ++i;
        }
        for (Object v : this.body.variables()) {
            if (variableMap.containsKey(v)) continue;
            variableMap.put(v, i++);
        }
        return new EncapsulatedRule(this.body.deny((TObjectIntHashMap<Object>)variableMap), var, i);
    }

    @Override
    public IPredicateQuery query(int[] var, int boundVariables) {
        TObjectIntHashMap variableMap = new TObjectIntHashMap();
        int i = 0;
        while (i < var.length) {
            variableMap.put(this.variables[i], i);
            ++i;
        }
        for (Object v : this.body.variables()) {
            if (variableMap.containsKey(v)) continue;
            variableMap.put(v, i++);
        }
        int[] var2 = new int[var.length];
        boolean[] bound = new boolean[variableMap.size()];
        int k = 0;
        int j = 0;
        while (j < var.length) {
            if ((boundVariables & 1 << j) != 0) {
                bound[k] = true;
                var2[var[j]] = k++;
            }
            ++j;
        }
        int boundLength = k;
        int j2 = 0;
        while (j2 < var.length) {
            if ((boundVariables & 1 << j2) == 0) {
                var2[var[j2]] = k++;
            }
            ++j2;
        }
        return new EncapsulatedQuery(this.body.query((TObjectIntHashMap<Object>)variableMap, bound), var2, i, boundLength);
    }

    static class Continuation {
        Object[] newBindings;
        Object continuation;

        public Continuation(Object[] newBindings, Object continuation) {
            this.newBindings = newBindings;
            this.continuation = continuation;
        }
    }

    class EncapsulatedQuery
    implements IPredicateQuery {
        IPredicateQuery query;
        int[] var;
        int boundLength;
        int length;

        public EncapsulatedQuery(IPredicateQuery query, int[] var, int length, int boundLength) {
            this.query = query;
            this.var = var;
            this.length = length;
            this.boundLength = boundLength;
        }

        @Override
        public Object query(ReadGraph g, Object[] bindings) throws DatabaseException {
            Object[] newBindings = new Object[this.length];
            int i = 0;
            while (i < this.boundLength) {
                newBindings[i] = bindings[this.var[i]];
                ++i;
            }
            Object cont = this.query.query(g, newBindings);
            if (cont == FAILURE) {
                return FAILURE;
            }
            int i2 = this.boundLength;
            while (i2 < this.var.length) {
                bindings[this.var[i2]] = newBindings[i2];
                ++i2;
            }
            if (cont == null) {
                return null;
            }
            return new Continuation(newBindings, cont);
        }

        @Override
        public Object next(ReadGraph g, Object[] bindings, Object _continuation) throws DatabaseException {
            Continuation continuation = (Continuation)_continuation;
            Object[] newBindings = continuation.newBindings;
            Object cont = this.query.next(g, newBindings, continuation.continuation);
            if (cont == FAILURE) {
                return FAILURE;
            }
            int i = this.boundLength;
            while (i < this.var.length) {
                bindings[this.var[i]] = newBindings[i];
                ++i;
            }
            if (cont == null) {
                return null;
            }
            continuation.continuation = cont;
            return continuation;
        }
    }

    class EncapsulatedRule
    implements IRule {
        IRule rule;
        int[] var;
        int length;

        public EncapsulatedRule(IRule rule, int[] var, int length) {
            this.rule = rule;
            this.var = var;
            this.length = length;
        }

        @Override
        public void doExecute(WriteGraph g, Object[] bindings) throws DatabaseException {
            Object[] newBindings = new Object[this.length];
            int i = 0;
            while (i < this.var.length) {
                newBindings[i] = bindings[this.var[i]];
                ++i;
            }
            this.rule.doExecute(g, newBindings);
        }

        @Override
        public IContextualModification execute(ReadGraph g, Object[] bindings) throws DatabaseException {
            final Object[] newBindings = new Object[this.length];
            int i = 0;
            while (i < this.var.length) {
                newBindings[i] = bindings[this.var[i]];
                ++i;
            }
            final IContextualModification modi = this.rule.execute(g, newBindings);
            if (modi == null) {
                return null;
            }
            if (modi.needsContext()) {
                return new IContextualModification(){

                    @Override
                    public boolean needsContext() {
                        return false;
                    }

                    @Override
                    public void perform(WriteGraph g, Object[] bindings) throws DatabaseException {
                        modi.perform(g, newBindings);
                    }
                };
            }
            return modi;
        }
    }
}

