/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.genericPredicates;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.genericPredicates.IBinaryPredicate2;
import org.simantics.layer0.utils.genericPredicates.IPredicate;
import org.simantics.layer0.utils.genericPredicates.IPredicateQuery;
import org.simantics.layer0.utils.genericPredicates.IRule;
import org.simantics.layer0.utils.genericPredicates.ObjectPair;

public class BinaryPredicateAdapter
implements IBinaryPredicate2 {
    static final int[] VARIABLE_LIST;
    IPredicate predicate;

    static {
        int[] nArray = new int[2];
        nArray[1] = 1;
        VARIABLE_LIST = nArray;
    }

    public BinaryPredicateAdapter(IPredicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public void claim(WriteGraph g, Object v0, Object v1) throws DatabaseException {
        this.predicate.claim(VARIABLE_LIST).doExecute(g, new Object[]{v0, v1});
    }

    @Override
    public void deny(WriteGraph g, Object v0, Object v1) throws DatabaseException {
        this.predicate.deny(VARIABLE_LIST).doExecute(g, new Object[]{v0, v1});
    }

    @Override
    public Collection<ObjectPair> get(ReadGraph g) throws DatabaseException {
        Object[] bindings;
        IPredicateQuery query = this.predicate.query(VARIABLE_LIST, 0);
        Object cont = query.query(g, bindings = new Object[2]);
        if (cont == IPredicateQuery.FAILURE) {
            return Collections.emptyList();
        }
        ArrayList<ObjectPair> result = new ArrayList<ObjectPair>();
        do {
            result.add(new ObjectPair(bindings[0], bindings[1]));
            if (cont != null) continue;
            return result;
        } while ((cont = query.query(g, bindings)) != IPredicateQuery.FAILURE);
        return result;
    }

    @Override
    public Collection<Object> getObjects(ReadGraph g, Object v0) throws DatabaseException {
        IPredicateQuery query = this.predicate.query(VARIABLE_LIST, 1);
        Object[] objectArray = new Object[2];
        objectArray[0] = v0;
        Object[] bindings = objectArray;
        Object cont = query.query(g, bindings);
        if (cont == IPredicateQuery.FAILURE) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        do {
            result.add(bindings[1]);
            if (cont != null) continue;
            return result;
        } while ((cont = query.query(g, bindings)) != IPredicateQuery.FAILURE);
        return result;
    }

    @Override
    public Collection<Object> getSubjects(ReadGraph g, Object v1) throws DatabaseException {
        IPredicateQuery query = this.predicate.query(VARIABLE_LIST, 2);
        Object[] objectArray = new Object[2];
        objectArray[1] = v1;
        Object[] bindings = objectArray;
        Object cont = query.query(g, bindings);
        if (cont == IPredicateQuery.FAILURE) {
            return Collections.emptyList();
        }
        ArrayList<Object> result = new ArrayList<Object>();
        do {
            result.add(bindings[0]);
            if (cont != null) continue;
            return result;
        } while ((cont = query.query(g, bindings)) != IPredicateQuery.FAILURE);
        return result;
    }

    @Override
    public boolean has(ReadGraph g, Object v0, Object v1) throws DatabaseException {
        return this.predicate.query(VARIABLE_LIST, 3).query(g, new Object[]{v0, v1}) != IPredicateQuery.FAILURE;
    }

    @Override
    public boolean supportsClaim() {
        return this.predicate.claim(VARIABLE_LIST) != null;
    }

    @Override
    public boolean supportsDeny() {
        return this.predicate.deny(VARIABLE_LIST) != null;
    }

    @Override
    public boolean supportsGet() {
        return this.predicate.query(VARIABLE_LIST, 0) != null;
    }

    @Override
    public boolean supportsGetObjects() {
        return this.predicate.query(VARIABLE_LIST, 1) != null;
    }

    @Override
    public boolean supportsGetSubjects() {
        return this.predicate.query(VARIABLE_LIST, 2) != null;
    }

    @Override
    public int arity() {
        return 2;
    }

    @Override
    public IRule claim(int[] variables) {
        return this.predicate.claim(variables);
    }

    @Override
    public IRule deny(int[] variables) {
        return this.predicate.deny(variables);
    }

    @Override
    public IPredicateQuery query(int[] variables, int boundVariables) {
        return this.predicate.query(variables, boundVariables);
    }

    public int hashCode() {
        return this.getClass().hashCode() + 31 * this.predicate.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        BinaryPredicateAdapter other = (BinaryPredicateAdapter)obj;
        return this.predicate.equals(other.predicate);
    }
}

