/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.genericPredicates;

import gnu.trove.TObjectIntHashMap;
import java.util.Arrays;
import java.util.Collection;
import org.simantics.layer0.utils.genericPredicates.IPredicate;
import org.simantics.layer0.utils.genericPredicates.IPredicateBody;
import org.simantics.layer0.utils.genericPredicates.IPredicateQuery;
import org.simantics.layer0.utils.genericPredicates.IRule;

public class Atom
implements IPredicateBody {
    IPredicate predicate;
    Object[] variables;

    public Atom(IPredicate predicate, Object[] variables) {
        assert (predicate.arity() == variables.length);
        this.predicate = predicate;
        this.variables = variables;
    }

    @Override
    public Collection<Object> variables() {
        return Arrays.asList(this.variables);
    }

    @Override
    public IRule claim(TObjectIntHashMap<Object> variableMap) {
        int[] var = new int[this.variables.length];
        int i = 0;
        while (i < var.length) {
            var[i] = variableMap.get(this.variables[i]);
            ++i;
        }
        return this.predicate.claim(var);
    }

    @Override
    public IRule deny(TObjectIntHashMap<Object> variableMap) {
        int[] var = new int[this.variables.length];
        int i = 0;
        while (i < var.length) {
            var[i] = variableMap.get(this.variables[i]);
            ++i;
        }
        return this.predicate.deny(var);
    }

    @Override
    public IPredicateQuery query(TObjectIntHashMap<Object> variableMap, boolean[] boundVariables) {
        int[] var = new int[this.variables.length];
        int boundVar = 0;
        int i = 0;
        while (i < var.length) {
            int id;
            var[i] = id = variableMap.get(this.variables[i]);
            if (boundVariables[id]) {
                boundVar |= 1 << i;
            } else {
                boundVariables[id] = true;
            }
            ++i;
        }
        return this.predicate.query(var, boundVar);
    }
}

