/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.direct;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.URIStringUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.exception.ValidationException;
import org.simantics.layer0.Layer0;
import org.simantics.layer0.utils.PropertyReference;

public final class ResourceNameUtils {
    public static final char NAME_PATH_DELIMITER = '/';
    public static final String NAME_PATH_DELIMITER_STRING = "/";

    public static String getName(ReadGraph g, Resource r) throws ValidationException, ServiceException {
        Layer0 b = Layer0.getInstance((ReadGraph)g);
        String name = (String)g.getPossibleRelatedValue(r, b.HasName);
        if (name == null) {
            return "#" + r.getResourceId();
        }
        return URIStringUtils.escape((String)name);
    }

    public static String getName(ReadGraph g, PropertyReference ref) throws DatabaseException {
        return ResourceNameUtils.getName(g, ref.resources);
    }

    public static String getName(ReadGraph g, Resource[] ref) throws DatabaseException {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        Resource[] resourceArray = ref;
        int n = ref.length;
        int n2 = 0;
        while (n2 < n) {
            Resource r = resourceArray[n2];
            if (first) {
                first = false;
            } else {
                b.append('/');
            }
            b.append(ResourceNameUtils.getName(g, r));
            ++n2;
        }
        return b.toString();
    }
}

