/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.binaryPredicates;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.binaryPredicates.BinaryPredicate;
import org.simantics.layer0.utils.binaryPredicates.IBinaryPredicate;
import org.simantics.utils.datastructures.Pair;

public class UnionPredicate
extends BinaryPredicate {
    Collection<IBinaryPredicate> predicates;

    public UnionPredicate(Collection<IBinaryPredicate> predicates) {
        this.predicates = predicates;
    }

    public UnionPredicate(IBinaryPredicate ... predicates) {
        this(Arrays.asList(predicates));
    }

    @Override
    public Collection<Resource> getObjects(ReadGraph g, Resource subject) throws DatabaseException {
        Iterator<IBinaryPredicate> it = this.predicates.iterator();
        while (it.hasNext()) {
            Collection<Resource> result = it.next().getObjects(g, subject);
            if (result.isEmpty()) continue;
            while (it.hasNext()) {
                Collection<Resource> temp = it.next().getObjects(g, subject);
                if (temp.isEmpty()) continue;
                HashSet<Resource> merged = new HashSet<Resource>(result.size() + temp.size());
                merged.addAll(result);
                merged.addAll(temp);
                while (it.hasNext()) {
                    merged.addAll(it.next().getObjects(g, subject));
                }
                return merged;
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<Pair<Resource, Resource>> getStatements(ReadGraph g) throws DatabaseException {
        Iterator<IBinaryPredicate> it = this.predicates.iterator();
        while (it.hasNext()) {
            Collection<Pair<Resource, Resource>> result = it.next().getStatements(g);
            if (result.isEmpty()) continue;
            while (it.hasNext()) {
                Collection<Pair<Resource, Resource>> temp = it.next().getStatements(g);
                if (temp.isEmpty()) continue;
                HashSet<Pair<Resource, Resource>> merged = new HashSet<Pair<Resource, Resource>>(result.size() + temp.size());
                merged.addAll(result);
                merged.addAll(temp);
                while (it.hasNext()) {
                    merged.addAll(it.next().getStatements(g));
                }
                return merged;
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public Collection<Resource> getSubjects(ReadGraph g, Resource object) throws DatabaseException {
        Iterator<IBinaryPredicate> it = this.predicates.iterator();
        while (it.hasNext()) {
            Collection<Resource> result = it.next().getSubjects(g, object);
            if (result.isEmpty()) continue;
            while (it.hasNext()) {
                Collection<Resource> temp = it.next().getSubjects(g, object);
                if (temp.isEmpty()) continue;
                HashSet<Resource> merged = new HashSet<Resource>(result.size() + temp.size());
                merged.addAll(result);
                merged.addAll(temp);
                while (it.hasNext()) {
                    merged.addAll(it.next().getSubjects(g, object));
                }
                return merged;
            }
            return result;
        }
        return Collections.emptyList();
    }

    @Override
    public boolean has(ReadGraph g, Resource subject, Resource object) throws DatabaseException {
        for (IBinaryPredicate pred : this.predicates) {
            if (!pred.has(g, subject, object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsGetObjects() {
        for (IBinaryPredicate pred : this.predicates) {
            if (pred.supportsGetObjects()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean supportsGetStatements() {
        for (IBinaryPredicate pred : this.predicates) {
            if (pred.supportsGetStatements()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean supportsGetSubjects() {
        for (IBinaryPredicate pred : this.predicates) {
            if (pred.supportsGetSubjects()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void add(WriteGraph g, Resource subject, Resource object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void remove(WriteGraph g, Resource subject, Resource object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsAdditions() {
        return false;
    }

    @Override
    public boolean supportsRemovals() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.predicates == null ? 0 : this.predicates.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UnionPredicate other = (UnionPredicate)obj;
        return !(this.predicates == null ? other.predicates != null : !this.predicates.equals(other.predicates));
    }
}

