/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.layer0.utils.binaryPredicates;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.binaryPredicates.BinaryPredicate;
import org.simantics.layer0.utils.binaryPredicates.IBinaryPredicate;
import org.simantics.utils.datastructures.Pair;

public class TransitiveClosure
extends BinaryPredicate {
    IBinaryPredicate predicate;

    public TransitiveClosure(IBinaryPredicate predicate) {
        this.predicate = predicate;
    }

    @Override
    public void add(WriteGraph g, Resource subject, Resource object) throws DatabaseException {
        if (!this.has((ReadGraph)g, subject, object)) {
            this.predicate.add(g, subject, object);
        }
    }

    @Override
    public Collection<Resource> getObjects(ReadGraph g, Resource subject) throws DatabaseException {
        ArrayDeque<Resource> unprocessed = new ArrayDeque<Resource>();
        unprocessed.add(subject);
        HashSet<Resource> result = new HashSet<Resource>();
        while (!unprocessed.isEmpty()) {
            for (Resource r : this.predicate.getObjects(g, (Resource)unprocessed.pop())) {
                if (!result.add(r)) continue;
                unprocessed.push(r);
            }
        }
        return result;
    }

    @Override
    public Collection<Pair<Resource, Resource>> getStatements(ReadGraph g) {
        return null;
    }

    @Override
    public Collection<Resource> getSubjects(ReadGraph g, Resource object) throws DatabaseException {
        ArrayDeque<Resource> unprocessed = new ArrayDeque<Resource>();
        unprocessed.add(object);
        HashSet<Resource> result = new HashSet<Resource>();
        while (!unprocessed.isEmpty()) {
            for (Resource r : this.predicate.getSubjects(g, (Resource)unprocessed.pop())) {
                if (!result.add(r)) continue;
                unprocessed.push(r);
            }
        }
        return result;
    }

    @Override
    public boolean has(ReadGraph g, Resource subject, Resource object) throws DatabaseException {
        ArrayDeque<Resource> unprocessed = new ArrayDeque<Resource>();
        unprocessed.add(subject);
        HashSet<Resource> objects = new HashSet<Resource>();
        while (!unprocessed.isEmpty()) {
            for (Resource r : this.predicate.getObjects(g, (Resource)unprocessed.pop())) {
                if (r.equals(object)) {
                    return true;
                }
                if (!objects.add(r)) continue;
                unprocessed.push(r);
            }
        }
        return false;
    }

    @Override
    public void remove(WriteGraph g, Resource subject, Resource object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean supportsAdditions() {
        return this.predicate.supportsAdditions();
    }

    @Override
    public boolean supportsGetObjects() {
        return this.predicate.supportsGetObjects();
    }

    @Override
    public boolean supportsGetStatements() {
        return false;
    }

    @Override
    public boolean supportsGetSubjects() {
        return this.predicate.supportsGetSubjects();
    }

    @Override
    public boolean supportsRemovals() {
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.predicate == null ? 0 : this.predicate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransitiveClosure other = (TransitiveClosure)obj;
        return !(this.predicate == null ? other.predicate != null : !this.predicate.equals(other.predicate));
    }
}

