/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.views.swt;

import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.simantics.Simantics;
import org.simantics.browsing.ui.common.ErrorLogger;
import org.simantics.browsing.ui.graph.impl.GraphInputSources;
import org.simantics.browsing.ui.graph.impl.InputSourceListener;
import org.simantics.browsing.ui.graph.impl.ObservableInputSource;
import org.simantics.browsing.ui.graph.impl.SessionContextInputSource;
import org.simantics.browsing.ui.graph.impl.WorkbenchSessionContextInputSource;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableRepository;
import org.simantics.db.request.ReadInterface;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.loader.ScenegraphLoaderProcess;
import org.simantics.views.ontology.ViewsResources;
import org.simantics.views.swt.ModelledView;
import org.simantics.views.swt.client.base.SWTRoot;

public class SWTViewLoaderProcess
extends ScenegraphLoaderProcess {
    private final ModelledView view;
    private final IWorkbenchSite site;
    ISL inputSourceListener = new ISL(this);

    public SWTViewLoaderProcess(ModelledView view, IWorkbenchSite site, String name) {
        super(name);
        this.view = view;
        this.site = site;
        this.root = new SWTRoot(site);
    }

    public SWTViewLoaderProcess(ModelledView view, IWorkbenchSite site) {
        this(view, site, "<unnamed SWTViewLoaderProcess>");
    }

    public INode getRoot() {
        return this.root;
    }

    protected void initialize(RequestProcessor processor, final Variable configuration) throws DatabaseException {
        SessionContextInputSource inputSource = (SessionContextInputSource)processor.sync((ReadInterface)new UniqueRead<SessionContextInputSource>(){

            public SessionContextInputSource perform(ReadGraph graph) throws DatabaseException {
                ViewsResources VIEW = ViewsResources.getInstance((ReadGraph)graph);
                Resource represents = (Resource)configuration.getPropertyValue(graph, "Represents");
                Resource inputSource = graph.getPossibleObject(represents, VIEW.HasInputSource);
                if (inputSource == null) {
                    return GraphInputSources.projectSource();
                }
                return (SessionContextInputSource)graph.adapt(inputSource, SessionContextInputSource.class);
            }
        });
        if (this.view != null) {
            this.view.setInputSource(inputSource);
        }
        if (inputSource instanceof ObservableInputSource) {
            ((ObservableInputSource)inputSource).setListener((InputSourceListener)this.inputSourceListener);
        }
        if (inputSource instanceof WorkbenchSessionContextInputSource) {
            ((WorkbenchSessionContextInputSource)inputSource).init(this.site, (IWorkbenchPart)this.view);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        this.inputSourceListener.dispose();
        for (String uri : this.registeredURIs) {
            VariableRepository.unregister((String)uri);
        }
        SWTRoot r = (SWTRoot)this.root;
        r.dispose();
        super.dispose();
    }

    public static class ISL
    implements InputSourceListener {
        private SWTViewLoaderProcess process;

        ISL(SWTViewLoaderProcess process) {
            this.process = process;
        }

        void dispose() {
            this.process = null;
        }

        public void inputChanged(SessionContextInputSource source) {
            if (this.process == null) {
                return;
            }
            Object input = source.get(Simantics.getSessionContext());
            if (input != null) {
                this.process.view.inputChanged(source.getProvider(), input);
            } else {
                ErrorLogger.defaultLogWarning((String)("input source " + source + " invalidly returned null"), (Throwable)new Exception("for stack trace only"));
            }
        }
    }
}

