/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.views.swt;

import java.util.Collections;
import java.util.Map;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.primitiverequest.PossibleObject;
import org.simantics.db.common.primitiverequest.RelatedValue2;
import org.simantics.db.common.primitiverequest.ResourceByURI;
import org.simantics.db.common.primitiverequest.SingleObject;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.WriteInterface;
import org.simantics.layer0.Layer0;
import org.simantics.scenegraph.loader.ScenegraphVariable;
import org.simantics.scenegraph.ontology.ScenegraphResources;
import org.simantics.utils.threads.SWTThread;
import org.simantics.views.ontology.ViewsResources;
import org.simantics.views.swt.SWTViewLoaderProcess;
import org.simantics.views.swt.client.base.SWTRoot;

public class ModelledDialogs {
    public static void scheduleMessage(String uri) {
        ModelledDialogs.scheduleMessage(uri, Collections.<String, Variant>emptyMap());
    }

    public static void scheduleMessage(final String uri, final Map<String, Variant> parameters) {
        SWTThread.getThreadAccess().asyncExec(new Runnable(){

            @Override
            public void run() {
                ModelledDialogs.openMessage(uri, parameters);
            }
        });
    }

    private static int getStyle(Resource type) throws DatabaseException {
        ViewsResources VIEWS = ViewsResources.getInstance((RequestProcessor)Simantics.getSession());
        if (VIEWS.MessageDialog_Type_Error.equals(type)) {
            return 1;
        }
        if (VIEWS.MessageDialog_Type_Information.equals(type)) {
            return 2;
        }
        if (VIEWS.MessageDialog_Type_Question.equals(type)) {
            return 3;
        }
        if (VIEWS.MessageDialog_Type_QuestionWithCancel.equals(type)) {
            return 6;
        }
        if (VIEWS.MessageDialog_Type_Confirm.equals(type)) {
            return 5;
        }
        if (VIEWS.MessageDialog_Type_Warning.equals(type)) {
            return 4;
        }
        throw new DatabaseException("MessageDialog model needs to define a dialog type");
    }

    public static int openMessage(String uri) {
        return ModelledDialogs.openMessage(uri, Collections.<String, Variant>emptyMap());
    }

    private static SWTRoot createCustomArea(final Resource customArea, final Map<String, Variant> parameters) throws DatabaseException {
        if (customArea == null) {
            return null;
        }
        final SWTViewLoaderProcess loader = new SWTViewLoaderProcess(null, null);
        Variable context = (Variable)Simantics.getSession().sync((WriteInterface)new WriteResultRequest<Variable>((VirtualGraph)Simantics.getSession().getService(VirtualGraph.class)){

            public Variable perform(WriteGraph graph) throws DatabaseException {
                Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                ScenegraphResources SG = ScenegraphResources.getInstance((ReadGraph)graph);
                Resource runtime = graph.newResource();
                graph.claim(runtime, L0.InstanceOf, null, SG.Runtime);
                Variable base = Variables.getVariable((ReadGraph)graph, (Resource)customArea);
                String uri = base.getURI((ReadGraph)graph);
                graph.claimLiteral(runtime, SG.Runtime_HasVariable, (Object)uri, (Binding)Bindings.STRING);
                return new ScenegraphVariable(base, customArea, runtime, loader.getRoot(), parameters);
            }
        });
        return (SWTRoot)loader.load((RequestProcessor)Simantics.getSession(), context);
    }

    public static int openMessage(String uri, Map<String, Variant> parameters) {
        try {
            Session session = Simantics.getSession();
            ViewsResources VIEWS = ViewsResources.getInstance((RequestProcessor)session);
            Resource configuration = (Resource)session.sync((ReadInterface)new ResourceByURI(uri));
            Resource typeResource = (Resource)session.sync((ReadInterface)new SingleObject(configuration, VIEWS.MessageDialog_HasType));
            int type = ModelledDialogs.getStyle(typeResource);
            String dialogTitle = (String)session.sync((ReadInterface)new RelatedValue2(configuration, VIEWS.MessageDialog_title, (Binding)Bindings.STRING));
            String dialogMessage = (String)session.sync((ReadInterface)new RelatedValue2(configuration, VIEWS.MessageDialog_message, (Binding)Bindings.STRING));
            String[] buttonLabels = (String[])session.sync((ReadInterface)new RelatedValue2(configuration, VIEWS.MessageDialog_buttonLabels, (Binding)Bindings.STRING_ARRAY));
            Integer defaultButton = (Integer)session.sync((ReadInterface)new RelatedValue2(configuration, VIEWS.MessageDialog_defaultButton, (Binding)Bindings.INTEGER));
            Resource customArea = (Resource)session.sync((ReadInterface)new PossibleObject(configuration, VIEWS.MessageDialog_HasCustomArea));
            SWTRoot root = ModelledDialogs.createCustomArea(customArea, parameters);
            class Dialog
            extends MessageDialog {
                private final /* synthetic */ SWTRoot val$root;

                public Dialog(String string, String string2, int n, String[] stringArray, Integer n2, SWTRoot sWTRoot) {
                    this.val$root = sWTRoot;
                    super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), string, null, string2, n, stringArray, n2.intValue());
                }

                protected Control createCustomArea(Composite parent) {
                    if (this.val$root != null) {
                        Composite customArea = new Composite(parent, 0);
                        customArea.setLayout((Layout)new GridLayout());
                        GridDataFactory.fillDefaults().grab(true, true).minSize(50, 50).applyTo((Control)customArea);
                        this.val$root.createControls(customArea);
                        return customArea;
                    }
                    return super.createCustomArea(parent);
                }
            }
            return new Dialog(dialogTitle, dialogMessage, type, buttonLabels, defaultButton, root).open();
        }
        catch (DatabaseException e) {
            Logger.defaultLogError((Throwable)e);
            return -1;
        }
    }
}

