/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend.impl;

import java.awt.Cursor;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PrinterException;
import java.io.File;
import java.io.IOException;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.util.Bean;
import org.simantics.g2d.canvas.Hints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.IMouseCursorHandle;
import org.simantics.g2d.canvas.impl.AbstractCanvasParticipant;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.canvas.impl.HintReflection;
import org.simantics.g2d.canvas.impl.SGNodeReflection;
import org.simantics.g2d.chassis.ITooltipProvider;
import org.simantics.g2d.participant.TimeParticipant;
import org.simantics.history.HistoryException;
import org.simantics.history.csv.CSVFormatter;
import org.simantics.history.util.ProgressMonitor;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.EventHandlerReflection;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.scenegraph.g2d.events.TimeEvent;
import org.simantics.scenegraph.g2d.events.command.CommandEvent;
import org.simantics.scenegraph.g2d.events.command.Commands;
import org.simantics.trend.configuration.ItemPlacement;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.trend.impl.HorizRuler;
import org.simantics.trend.impl.ItemNode;
import org.simantics.trend.impl.Milestone;
import org.simantics.trend.impl.MouseCursors;
import org.simantics.trend.impl.Plot;
import org.simantics.trend.impl.SelectionNode;
import org.simantics.trend.impl.TextNode;
import org.simantics.trend.impl.TrendNode;
import org.simantics.trend.impl.VertRuler;
import org.simantics.trend.util.PrintUtil;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class TrendParticipant
extends AbstractCanvasParticipant {
    public static final IHintContext.Key KEY_TREND_DRAW_INTERVAL = new IHintContext.KeyOf(Long.class);
    public static final IHintContext.Key KEY_TREND_SHAPE_LAST = new IHintContext.KeyOf(Long.class);
    public static final IHintContext.Key KEY_TREND_AUTOSCALE_INTERVAL = new IHintContext.KeyOf(Long.class);
    public static final IHintContext.Key KEY_TREND_AUTOSCALE_LAST = new IHintContext.KeyOf(Long.class);
    public static final double KEY_MOVE = 0.33;
    public MouseCursors cursors = new MouseCursors();
    TrendNode trend;
    @DependencyReflection.Dependency
    TimeParticipant time;
    Grab grab;
    public ItemNode hoveringItem;

    @HintReflection.HintListener(Class=Hints.class, Field="KEY_CONTROL_BOUNDS")
    public void selectionChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
        this.trend.shapedirty = true;
        this.setDirty();
    }

    public void addedToContext(ICanvasContext ctx) {
        super.addedToContext(ctx);
        this.time.registerForEvents(((Object)((Object)this)).getClass());
    }

    public void setTrend(TrendNode node) {
        this.trend = node;
    }

    public TrendNode getTrend() {
        return this.trend;
    }

    @SGNodeReflection.SGCleanup
    public void cleanupSG() {
    }

    protected void updateNode() {
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleTimeEvent(TimeEvent e) {
        Long autoscaleTime;
        boolean autoscale;
        Long autoscaleInterval;
        Long lastDrawTime;
        boolean drawIntervalElapsed;
        if (this.isRemoved()) {
            if (this.time != null) {
                this.time.unregisterForEvents(((Object)((Object)this)).getClass());
            }
            return false;
        }
        long currentTime = e.time;
        Long drawInterval = (Long)this.getHint(KEY_TREND_DRAW_INTERVAL);
        if (drawInterval == null) {
            drawInterval = 200L;
        }
        boolean bl = drawIntervalElapsed = (lastDrawTime = (Long)this.getHint(KEY_TREND_SHAPE_LAST)) == null || currentTime >= lastDrawTime + drawInterval;
        if (drawIntervalElapsed) {
            this.setHint(KEY_TREND_SHAPE_LAST, currentTime);
            this.trend.shapedirty |= this.trend.datadirty;
            this.trend.datadirty = false;
        }
        if ((autoscaleInterval = (Long)this.getHint(KEY_TREND_AUTOSCALE_INTERVAL)) == null) {
            autoscaleInterval = 1000L;
        }
        boolean bl2 = autoscale = (autoscaleTime = (Long)this.getHint(KEY_TREND_AUTOSCALE_LAST)) == null || currentTime >= autoscaleTime + autoscaleInterval;
        if (autoscale) {
            boolean l = this.trend.autoscale(this.trend.autoscaletime, autoscale);
            if (l) {
                this.trend.layout();
            }
            this.setHint(KEY_TREND_AUTOSCALE_LAST, currentTime);
        }
        if (this.trend.shapedirty) {
            this.setDirty();
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean mouseClick(MouseEvent.MouseClickEvent me) {
        IG2DNode node = this.trend.pickNode(me.controlPosition);
        if (me.clickCount == 2 && node != null) {
            this.trend.valueTipTime = this.trend.prevValueTipTime;
            if (node instanceof Plot) {
                boolean binaryArea;
                boolean bl = binaryArea = me.controlPosition.getY() > this.trend.plot.getY() + this.trend.plot.analogAreaHeight;
                if (binaryArea) {
                    this.trend.horizRuler.zoomOut();
                } else {
                    this.trend.zoomOut();
                }
                this.setDirty();
                return true;
            }
            if (node instanceof HorizRuler) {
                HorizRuler hr = (HorizRuler)node;
                hr.zoomOut();
                this.setDirty();
                return true;
            }
            if (node instanceof VertRuler) {
                VertRuler vr = (VertRuler)node;
                vr.zoomOut();
                this.setDirty();
                return true;
            }
        }
        if (me.clickCount == 1 && me.button == 1 && node != null && node instanceof Plot) {
            this.trend.prevValueTipTime = this.trend.valueTipTime;
            if (this.trend.valueTipTime == null) {
                this.trend.valueTipTime = Double.isNaN(this.trend.mouseHoverTime) ? null : Double.valueOf(this.trend.mouseHoverTime);
                this.trend.valueTipHover = true;
            } else {
                boolean hit;
                double valueTipX = this.trend.horizRuler.toX(this.trend.valueTipTime);
                double x = me.controlPosition.getX() - this.trend.horizRuler.getBounds().getX();
                boolean bl = hit = x >= valueTipX - 3.0 && x <= valueTipX + 3.0;
                if (hit) {
                    this.trend.valueTipTime = null;
                }
            }
            this.setDirty();
        }
        if (me.clickCount == 1 && me.button == 1) {
            if (node instanceof VertRuler) {
                VertRuler vr = (VertRuler)node;
                this.trend.selectVertRuler(this.trend.vertRulers.indexOf(vr));
                this.setDirty();
            } else if (node == null || node instanceof TextNode) {
                Plot p = this.trend.plot;
                double x = me.controlPosition.getX() - p.getX();
                double y = me.controlPosition.getY() - p.getY();
                if (x >= 0.0 && x <= p.getWidth() && y <= 0.0 && y >= -14.0) {
                    for (Milestone ms : this.trend.milestones.milestones) {
                        double mx = this.trend.horizRuler.toX(ms.time);
                        if (!(x >= mx - 7.0) || !(x <= mx + 7.0)) continue;
                        ITooltipProvider tp = this.getContext().getTooltipProvider();
                        if (tp == null) break;
                        tp.show(new String[]{ms.label, ms.description});
                        break;
                    }
                }
            }
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean mouseDown(MouseEvent.MouseButtonPressedEvent me) {
        IG2DNode node;
        if (me.button == 1 && ((node = this.trend.pickNode(me.controlPosition)) == null || node instanceof Plot)) {
            boolean timeZoom;
            if (this.trend.valueTipTime != null) {
                boolean hit;
                double valueTipX = this.trend.horizRuler.toX(this.trend.valueTipTime);
                double x = me.controlPosition.getX() - this.trend.horizRuler.getBounds().getX();
                boolean bl = hit = x >= valueTipX - 3.0 && x <= valueTipX + 3.0;
                if (hit) {
                    this.grab = new Grab();
                    this.grab.mousepos = new Point2D.Double(me.controlPosition.getX(), me.controlPosition.getY());
                    this.grab.sx = this.trend.horizRuler.unitsPerPixel();
                    this.grab.sy = new double[this.trend.vertRulers.size()];
                    this.grab.valueTipGrab = true;
                    return true;
                }
            }
            boolean binaryArea = me.controlPosition.getY() > this.trend.plot.getY() + this.trend.plot.analogAreaHeight;
            boolean bl = timeZoom = (me.stateMask & 0x40) > 0 || binaryArea;
            if (this.trend.selection == null) {
                this.trend.selection = (SelectionNode)((Object)this.trend.addNode("Selection", SelectionNode.class));
                this.trend.selection.setZIndex(10);
                this.trend.selection.start(me.controlPosition, binaryArea, timeZoom);
            }
            return true;
        }
        node = this.trend.pickNode(me.controlPosition);
        if (me.button == 3 && node != null && node instanceof Plot) {
            TrendNode trend = (TrendNode)node.getParent();
            boolean shift = (me.stateMask & 0x40) > 0;
            boolean alt = (me.stateMask & 0x200) > 0;
            this.grab = new Grab();
            this.grab.mousepos = new Point2D.Double(me.controlPosition.getX(), me.controlPosition.getY());
            this.grab.sx = trend.horizRuler.unitsPerPixel();
            this.grab.sy = new double[trend.vertRulers.size()];
            this.grab.horiz = !shift || alt;
            boolean bl = this.grab.vert = shift || alt;
            if (this.grab.vert) {
                int i = 0;
                while (i < trend.vertRulers.size()) {
                    this.grab.sy[i] = trend.vertRulers.get(i).unitsPerPixel();
                    ++i;
                }
            }
            Cursor c = this.grab.horiz ? (this.grab.vert ? this.cursors.grab : this.cursors.grab_horiz) : (this.grab.vert ? this.cursors.grab_vert : this.cursors.grab);
            this.grab.cursor = this.getContext().getMouseCursorContext().setCursor(me.mouseId, c);
            this.grab.mouseButton = me.button;
            this.grab.plot = true;
            trend.horizRuler.translate(0.0);
            this.setHoverTime(null);
            this.setDirty();
            return true;
        }
        if ((me.button == 1 || me.button == 3) && node != null && node instanceof HorizRuler) {
            HorizRuler hr = (HorizRuler)node;
            this.grab = new Grab();
            this.grab.cursor = this.getContext().getMouseCursorContext().setCursor(me.mouseId, this.cursors.grab_horiz);
            this.grab.mousepos = new Point2D.Double();
            this.grab.mousepos.setLocation(me.controlPosition);
            this.grab.sx = hr.unitsPerPixel();
            this.grab.horizRuler = true;
            this.grab.mouseButton = me.button;
            this.grab.horiz = true;
            this.trend.horizRuler.translate(0.0);
            this.setDirty();
            return true;
        }
        if ((me.button == 1 || me.button == 3) && node != null && node instanceof VertRuler) {
            this.grab = new Grab();
            this.grab.cursor = this.getContext().getMouseCursorContext().setCursor(me.mouseId, this.cursors.grab_vert);
            this.grab.mousepos = new Point2D.Double();
            this.grab.mousepos.setLocation(me.controlPosition);
            this.grab.sy = new double[this.trend.vertRulers.size()];
            int i = 0;
            while (i < this.trend.vertRulers.size()) {
                this.grab.sy[i] = this.trend.vertRulers.get(i).unitsPerPixel();
                ++i;
            }
            this.grab.mouseButton = me.button;
            this.grab.vertRuler = this.trend.vertRulers.indexOf(node);
            this.trend.selectVertRuler(this.grab.vertRuler);
            this.setDirty();
            return true;
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean mouseUp(MouseEvent.MouseButtonReleasedEvent me) {
        if (me.button == 1 && this.grab != null && this.grab.valueTipGrab) {
            this.grab = null;
        }
        if (me.button == 1 && this.trend.selection != null) {
            Rectangle2D.Double rect = this.trend.selection.rect;
            if (((RectangularShape)rect).getWidth() > 1.0 && ((RectangularShape)rect).getHeight() > 1.0) {
                if (this.trend.selection.timeZoom) {
                    this.trend.horizRuler.zoomIn(((RectangularShape)rect).getX() - this.trend.horizRuler.getX(), ((RectangularShape)rect).getWidth());
                } else {
                    this.trend.zoomIn(((RectangularShape)rect).getX() - this.trend.plot.getX(), ((RectangularShape)rect).getY() - this.trend.plot.getY(), ((RectangularShape)rect).getWidth(), ((RectangularShape)rect).getHeight(), true, true);
                }
                this.trend.layout();
                this.trend.shapedirty = true;
                this.setDirty();
            }
            this.trend.selection.delete();
            this.trend.selection = null;
            return true;
        }
        if (this.grab != null && this.grab.mouseButton == me.button) {
            this.grab.cursor.remove();
            this.grab = null;
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean mouseExit(MouseEvent.MouseExitEvent me) {
        this.trend.valueTipHover = false;
        this.setHoverTime(null);
        return false;
    }

    void setHoverTime(Double time) {
        if (time == null && Double.isNaN(this.trend.mouseHoverTime)) {
            return;
        }
        if (time != null && this.trend.mouseHoverTime == time) {
            return;
        }
        if (time == null) {
            this.trend.mouseHoverTime = Double.NaN;
        } else {
            this.trend.mouseHoverTime = time;
            this.trend.lastMouseHoverTime = time;
        }
        this.setDirty();
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean mouseEnter(MouseEvent.MouseExitEvent me) {
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean mouseMoved(MouseEvent.MouseMovedEvent me) {
        ITooltipProvider tt = this.getContext().getTooltipProvider();
        IG2DNode pick = this.trend.pickNode(me.controlPosition);
        if (pick == this.trend.plot) {
            boolean shift;
            double x = me.controlPosition.getX() - this.trend.horizRuler.getBounds().getX();
            double time = this.trend.horizRuler.toTime(x);
            double sx = (this.trend.horizRuler.end - this.trend.horizRuler.from) / this.trend.horizRuler.getWidth();
            double timeSnapTolerance = sx * 7.0;
            boolean bl = shift = (me.stateMask & 0x40) > 0;
            if (shift) {
                Double snappedTime = null;
                try {
                    snappedTime = this.trend.snapToValue(time, timeSnapTolerance);
                    if (snappedTime != null) {
                        time = snappedTime;
                    }
                }
                catch (HistoryException historyException) {
                }
                catch (AccessorException accessorException) {
                    // empty catch block
                }
            }
            this.setHoverTime(time);
        }
        if (pick == this.trend.plot) {
            if (this.grab != null && this.grab.valueTipGrab) {
                this.trend.valueTipTime = Double.isNaN(this.trend.mouseHoverTime) ? null : Double.valueOf(this.trend.mouseHoverTime);
                return false;
            }
            if (this.trend.valueTipTime != null) {
                boolean hit;
                double valueTipX = this.trend.horizRuler.toX(this.trend.valueTipTime);
                double x = me.controlPosition.getX() - this.trend.horizRuler.getBounds().getX();
                this.trend.valueTipHover = hit = x >= valueTipX - 3.0 && x <= valueTipX + 3.0;
            }
        }
        if (pick instanceof VertRuler) {
            VertRuler vr = (VertRuler)pick;
            this.hoveringItem = null;
            for (ItemNode item : this.trend.analogItems) {
                if (item.item.renderer == TrendItem.Renderer.Analog && item.ruler != vr) continue;
                if (this.hoveringItem == null) {
                    this.hoveringItem = item;
                    continue;
                }
                break;
            }
        } else {
            this.hoveringItem = pick == null || pick instanceof Plot ? this.trend.plot.pickItem(me.controlPosition) : null;
        }
        if (this.trend.selection != null) {
            this.trend.selection.setEndPoint(me.controlPosition);
            this.setHoverTime(null);
            this.setDirty();
            return true;
        }
        if (this.grab != null) {
            double dx = me.controlPosition.getX() - this.grab.mousepos.x;
            double dy = me.controlPosition.getY() - this.grab.mousepos.y;
            this.grab.mousepos.setLocation(me.controlPosition);
            if (this.grab.plot) {
                if (this.grab.horiz) {
                    this.trend.horizRuler.translate(-dx * this.grab.sx);
                }
                if (this.grab.vert) {
                    int i = 0;
                    while (i < this.grab.sy.length) {
                        if (i < this.trend.vertRulers.size()) {
                            this.trend.vertRulers.get(i).translate(dy * this.grab.sy[i]);
                            ++i;
                            continue;
                        }
                        break;
                    }
                }
            } else if (this.grab.horizRuler) {
                this.trend.horizRuler.translate(-dx * this.grab.sx);
            } else if (this.grab.vertRuler >= 0 && this.grab.vertRuler <= this.trend.vertRulers.size()) {
                VertRuler vr = this.trend.vertRulers.get(this.grab.vertRuler);
                this.trend.selectVertRuler(this.grab.vertRuler);
                vr.translate(dy * this.grab.sy[this.grab.vertRuler]);
            }
            this.trend.layout();
            this.trend.shapedirty = true;
            this.setDirty();
            return true;
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean mouseWheel(MouseEvent.MouseWheelMovedEvent me) {
        IG2DNode node = this.trend.pickNode(me.controlPosition);
        if (node instanceof Plot || node instanceof HorizRuler || node instanceof VertRuler) {
            Point2D pt = node.parentToLocal(me.controlPosition);
            boolean shift = (me.stateMask & 0x40) > 0;
            boolean alt = (me.stateMask & 0x200) > 0;
            double pw = this.trend.plot.getWidth();
            double ph = this.trend.plot.analogAreaHeight;
            double r = Math.pow(0.9, me.wheelRotation);
            double w = r * pw;
            double h = r * ph;
            double rx = pt.getX() / pw;
            double ry = pt.getY() / ph;
            double zx = (pw - w) * rx;
            double zy = (ph - h) * ry;
            if (node instanceof Plot) {
                TrendNode trend = (TrendNode)node.getParent();
                if (shift || alt) {
                    for (VertRuler vr : trend.vertRulers) {
                        vr.zoomIn(zy, h);
                    }
                }
                if (!shift) {
                    trend.horizRuler.zoomIn(zx, w);
                }
            }
            if (node instanceof HorizRuler) {
                this.trend.horizRuler.zoomIn(zx, w);
            }
            if (node instanceof VertRuler) {
                VertRuler vr = (VertRuler)node;
                this.trend.selectVertRuler(this.trend.vertRulers.indexOf(vr));
                vr.zoomIn(zy, h);
            }
            this.trend.shapedirty = true;
            this.trend.layout();
            this.setDirty();
            return true;
        }
        return false;
    }

    @EventHandlerReflection.EventHandler(priority=0)
    public boolean handleCommandEvent(CommandEvent e) {
        double w;
        double za;
        double zy;
        double zx;
        double ph;
        double pw;
        if (e.command == Commands.CANCEL) {
            if (this.trend.selection != null) {
                this.trend.selection.delete();
                this.trend.selection = null;
                this.setDirty();
                return true;
            }
            if (this.grab != null) {
                if (this.grab.cursor != null) {
                    this.grab.cursor.remove();
                }
                this.grab = null;
                return true;
            }
            if (this.trend.valueTipTime != null) {
                this.trend.valueTipTime = null;
                this.setDirty();
                return true;
            }
            return false;
        }
        if (e.command == Commands.PAN_LEFT) {
            pw = this.trend.plot.getWidth();
            ph = this.trend.plot.analogAreaHeight;
            zx = -pw * 0.33;
            zy = 0.0;
            this.trend.zoomIn(zx, zy, pw, ph, true, true);
            this.trend.layout();
            this.setDirty();
        }
        if (e.command == Commands.PAN_RIGHT) {
            pw = this.trend.plot.getWidth();
            ph = this.trend.plot.analogAreaHeight;
            zx = pw * 0.33;
            zy = 0.0;
            this.trend.zoomIn(zx, zy, pw, ph, true, true);
            this.trend.horizRuler.autoscroll = false;
            this.trend.layout();
            this.setDirty();
        }
        if (e.command == Commands.PAN_UP) {
            pw = this.trend.plot.getWidth();
            ph = this.trend.plot.analogAreaHeight;
            zx = 0.0;
            zy = -ph * 0.33;
            this.trend.zoomIn(zx, zy, pw, ph, true, true);
            this.trend.horizRuler.autoscroll = false;
            this.trend.layout();
            this.setDirty();
        }
        if (e.command == Commands.PAN_DOWN) {
            pw = this.trend.plot.getWidth();
            ph = this.trend.plot.analogAreaHeight;
            zx = 0.0;
            zy = ph * 0.33;
            this.trend.zoomIn(zx, zy, pw, ph, true, true);
            this.trend.horizRuler.autoscroll = false;
            this.trend.layout();
            this.setDirty();
        }
        if (e.command.equals((Object)Commands.AUTOSCALE)) {
            this.trend.horizRuler.autoscroll = true;
            for (VertRuler vertRuler : this.trend.vertRulers) {
                vertRuler.autoscroll = true;
            }
            this.trend.zoomOut();
            this.trend.layout();
            this.setDirty();
        }
        if (e.command.equals((Object)Commands.ZOOM_TO_FIT)) {
            this.trend.readMinMaxFromEnd();
            this.trend.horizRuler.setFromEnd(this.trend.horizRuler.iFrom, this.trend.horizRuler.iEnd);
            this.trend.horizRuler.fireListener();
            int c = this.trend.vertRulers.size();
            int i = 0;
            while (i < c) {
                VertRuler vr = this.trend.vertRulers.get(c - i - 1);
                double nMax = vr.iMax;
                double nMin = vr.iMin;
                double diff = nMax - nMin;
                if (diff == 0.0) {
                    diff = (nMax += 0.5) - (nMin -= 0.5);
                }
                double margin = diff * 0.02;
                if (this.trend.itemPlacement == ItemPlacement.Stacked) {
                    nMin = nMin - diff * (double)i - margin;
                    nMax = nMax + diff * (double)(c - i - 1) + margin;
                } else {
                    nMin = vr.iMin - margin;
                    nMax = vr.iMax + margin;
                }
                vr.zoomTo(nMin, nMax);
                ++i;
            }
            this.trend.horizRuler.autoscroll = false;
            this.trend.layout();
            this.setDirty();
            return true;
        }
        if (e.command.equals((Object)Commands.ZOOM_TO_FIT_HORIZ)) {
            this.trend.readMinMaxFromEnd();
            this.trend.horizRuler.setFromEnd(this.trend.horizRuler.iFrom, this.trend.horizRuler.iEnd);
            this.trend.layout();
            this.trend.horizRuler.autoscroll = false;
            this.setDirty();
            return true;
        }
        if (e.command.equals((Object)Commands.ZOOM_TO_FIT_VERT)) {
            this.trend.readMinMaxFromEnd();
            int c = this.trend.vertRulers.size();
            int i = 0;
            while (i < c) {
                VertRuler vr = this.trend.vertRulers.get(c - i - 1);
                double nMax = vr.iMax;
                double nMin = vr.iMin;
                double diff = nMax - nMin;
                if (diff == 0.0) {
                    diff = (nMax += 0.5) - (nMin -= 0.5);
                }
                double margin = diff * 0.02;
                if (this.trend.itemPlacement == ItemPlacement.Stacked) {
                    nMin = nMin - diff * (double)i - margin;
                    nMax = nMax + diff * (double)(c - i - 1) + margin;
                } else {
                    nMin = vr.iMin - margin;
                    nMax = vr.iMax + margin;
                }
                vr.zoomTo(nMin, nMax);
                ++i;
            }
            this.trend.layout();
            this.setDirty();
            return true;
        }
        if (e.command == Commands.ZOOM_IN) {
            double pw2 = this.trend.plot.getWidth();
            ph = this.trend.plot.analogAreaHeight;
            za = 3.0;
            w = (1.0 - 0.1 * za) * pw2;
            double h = (1.0 - 0.1 * za) * ph;
            double zx2 = (pw2 - w) / 2.0;
            double zy2 = (ph - h) / 2.0;
            this.trend.zoomIn(zx2, zy2, w, h, true, true);
            this.trend.horizRuler.autoscroll = false;
            this.trend.layout();
            this.setDirty();
            return true;
        }
        if (e.command == Commands.ZOOM_OUT) {
            double pw3 = this.trend.plot.getWidth();
            ph = this.trend.plot.analogAreaHeight;
            za = -3.0;
            w = (1.0 - 0.1 * za) * pw3;
            double h = (1.0 - 0.1 * za) * ph;
            double zx3 = (pw3 - w) / 2.0;
            double zy3 = (ph - h) / 2.0;
            this.trend.zoomIn(zx3, zy3, w, h, true, true);
            this.trend.horizRuler.autoscroll = false;
            this.trend.layout();
            this.setDirty();
            return true;
        }
        if (e.command == Commands.PRINT) {
            try {
                PrintUtil pu = new PrintUtil();
                pu.addTrendPage(this.trend);
                pu.print();
            }
            catch (PrinterException e1) {
                e1.printStackTrace();
            }
            return true;
        }
        if (e.command == Commands.PDFPRINT) {
            PrintUtil pu = new PrintUtil();
            pu.addTrendPage(this.trend);
            try {
                File f = File.createTempFile("Trend", ".pdf");
                pu.printPdf(f);
                System.out.println("Printed Trend to " + f);
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return true;
        }
        if (e.command == Commands.COPY || e.command == Commands.EXPORT) {
            StringBuilder sb = new StringBuilder(65536);
            try {
                CSVFormatter formatter = new CSVFormatter();
                formatter.setTimeRange(this.trend.horizRuler.from, this.trend.horizRuler.end);
                for (ItemNode i : this.trend.allItems) {
                    if (i.historyItems == null || i.historyItems.length == 0) continue;
                    Bean bestQualityStream = i.historyItems[0];
                    String historyItemId = (String)bestQualityStream.getFieldUnchecked("id");
                    formatter.addItem(this.trend.historian, historyItemId, i.item.simpleLabel, i.item.variableReference, i.item.unit);
                }
                formatter.sort();
                try {
                    formatter.formulate2((ProgressMonitor)new ProgressMonitor.Stub(), (Appendable)sb);
                }
                catch (IOException i) {}
            }
            catch (HistoryException e1) {
                e1.toString();
            }
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Clipboard clipboard = toolkit.getSystemClipboard();
            StringSelection strSel = new StringSelection(sb.toString());
            clipboard.setContents(strSel, null);
        }
        return false;
    }

    static class Grab {
        int mouseButton;
        IMouseCursorHandle cursor;
        Point2D.Double mousepos = new Point2D.Double();
        boolean plot = false;
        boolean horizRuler = false;
        boolean vert = false;
        boolean horiz = false;
        int vertRuler = -1;
        double sx = 1.0;
        double[] sy;
        boolean valueTipGrab = false;

        Grab() {
        }
    }
}

