/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.accessor.error.AccessorException;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.util.Bean;
import org.simantics.history.Collector;
import org.simantics.history.History;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.impl.CollectorImpl;
import org.simantics.history.util.Stream;
import org.simantics.history.util.ValueBand;
import org.simantics.scenegraph.INode;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.utils.QualityHints;
import org.simantics.trend.configuration.ItemPlacement;
import org.simantics.trend.configuration.LineQuality;
import org.simantics.trend.configuration.Scale;
import org.simantics.trend.configuration.TimeFormat;
import org.simantics.trend.configuration.TimeWindow;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.trend.configuration.TrendQualitySpec;
import org.simantics.trend.configuration.TrendSpec;
import org.simantics.trend.configuration.Viewport;
import org.simantics.trend.configuration.YAxisMode;
import org.simantics.trend.impl.HorizRuler;
import org.simantics.trend.impl.ItemNode;
import org.simantics.trend.impl.JarisPaints;
import org.simantics.trend.impl.Milestone;
import org.simantics.trend.impl.MilestoneSpec;
import org.simantics.trend.impl.Plot;
import org.simantics.trend.impl.SelectionNode;
import org.simantics.trend.impl.TextNode;
import org.simantics.trend.impl.TrendLayout;
import org.simantics.trend.impl.VertRuler;
import org.simantics.utils.format.ValueFormat;

public class TrendNode
extends G2DParentNode
implements TrendLayout {
    private static final long serialVersionUID = -8339696405893626168L;
    public TextNode titleNode;
    public Plot plot;
    public HorizRuler horizRuler;
    VertRuler vertRuler;
    int vertRulerIndex;
    List<VertRuler> vertRulers = new ArrayList<VertRuler>();
    SelectionNode selection;
    public MilestoneSpec milestones;
    Rectangle2D bounds = new Rectangle2D.Double();
    public TrendSpec spec;
    public TrendQualitySpec quality = TrendQualitySpec.DEFAULT;
    public boolean printing = false;
    boolean singleAxis;
    List<ItemNode> analogItems = new ArrayList<ItemNode>();
    List<ItemNode> binaryItems = new ArrayList<ItemNode>();
    List<ItemNode> allItems = new ArrayList<ItemNode>();
    static HistoryManager DUMMY_HISTORY = History.createMemoryHistory();
    public HistoryManager historian = DUMMY_HISTORY;
    public Collector collector = null;
    Set<String> itemIds = new HashSet<String>();
    public boolean datadirty = false;
    public boolean shapedirty = false;
    public boolean autoscaletime = true;
    public TimeFormat timeFormat = TimeFormat.Time;
    public ValueFormat valueFormat = ValueFormat.Default;
    public boolean drawSamples = false;
    public double mouseHoverTime = Double.NaN;
    public double lastMouseHoverTime = 0.0;
    public Double valueTipTime = null;
    public Double prevValueTipTime = null;
    public boolean valueTipHover = false;
    public ItemPlacement itemPlacement = ItemPlacement.Overlapping;

    public void init() {
        this.spec = new TrendSpec();
        this.spec.init();
        this.milestones = new MilestoneSpec();
        this.milestones.init();
        this.titleNode = (TextNode)this.addNode("Title", TextNode.class);
        this.titleNode.setFont(new Font("Arial", 0, 30));
        this.titleNode.setColor(Color.BLACK);
        this.titleNode.setText("<title here>");
        this.titleNode.setSize(300.0, 40.0);
        this.plot = (Plot)this.addNode("Plot", Plot.class);
        this.horizRuler = (HorizRuler)this.addNode("HorizRuler", HorizRuler.class);
        this.vertRuler = (VertRuler)this.addNode("VertRuler", VertRuler.class);
        this.vertRulers.add(this.vertRuler);
        this.horizRuler.setFromEnd(0.0, 100.0);
        this.vertRuler.setMinMax(0.0, 100.0);
        this.setSize(480.0, 320.0);
    }

    public void setHistorian(HistoryManager historian, Collector collector) {
        this.historian = historian == null ? DUMMY_HISTORY : historian;
        this.collector = collector;
        this.itemIds.clear();
        Bean[] allFiles = this.getHistoryItems();
        for (ItemNode item : this.allItems) {
            item.setTrendItem(item.item, allFiles);
            Bean[] beanArray = item.historyItems;
            int n = item.historyItems.length;
            int n2 = 0;
            while (n2 < n) {
                Bean historyItem = beanArray[n2];
                try {
                    this.itemIds.add((String)historyItem.getField("id"));
                }
                catch (BindingException bindingException) {
                    // empty catch block
                }
                ++n2;
            }
        }
    }

    Bean[] getHistoryItems() {
        Bean[] result = null;
        HistoryException e = null;
        int attempt = 0;
        while (attempt < 10) {
            try {
                result = this.historian.getItems();
                break;
            }
            catch (HistoryException e2) {
                if (e == null) {
                    e = e2;
                }
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ++attempt;
            }
        }
        if (result != null) {
            return result;
        }
        return new Bean[0];
    }

    public void setMilestones(Bean milestones) {
        double newBasetime;
        if (this.milestones.equals(milestones)) {
            return;
        }
        this.milestones.readFrom(milestones);
        boolean hasBaseline = this.milestones.baseline >= 0;
        final Milestone baseline = this.milestones.baseline >= 0 ? this.milestones.milestones.get(this.milestones.baseline) : null;
        Collections.sort(this.milestones.milestones, new Comparator<Milestone>(){

            @Override
            public int compare(Milestone o1, Milestone o2) {
                if (o1 == baseline) {
                    return -1;
                }
                if (o2 == baseline) {
                    return 1;
                }
                return Double.compare(o1.time, o1.time);
            }
        });
        this.milestones.baseline = hasBaseline ? 0 : -1;
        double d = newBasetime = hasBaseline ? this.milestones.milestones.get((int)this.milestones.baseline).time : 0.0;
        if (newBasetime != this.horizRuler.basetime) {
            this.horizRuler.basetime = newBasetime;
            this.horizRuler.layout();
        }
        this.shapedirty = true;
    }

    public void selectVertRuler(int index) {
        this.vertRulerIndex = index;
        this.vertRuler = index < 0 || index >= this.vertRulers.size() ? this.vertRulers.get(0) : this.vertRulers.get(index);
        this.shapedirty = true;
    }

    public void cleanup() {
        this.spec = new TrendSpec();
        this.spec.init();
        this.analogItems.clear();
        this.binaryItems.clear();
        this.allItems.clear();
        this.historian = DUMMY_HISTORY;
        super.cleanup();
    }

    public void setTrendSpec(TrendSpec newSpec) {
        Object item;
        if (newSpec.equals((Object)this.spec)) {
            return;
        }
        boolean timeWindowChange = false;
        timeWindowChange = !this.spec.viewProfile.timeWindow.equals((Object)newSpec.viewProfile.timeWindow);
        this.spec.readFrom(newSpec);
        this.spec.sortItems();
        this.itemIds.clear();
        if (this.titleNode != null) {
            this.titleNode.setText(this.spec.name);
        }
        for (VertRuler vr : this.vertRulers) {
            this.removeNode((INode)vr);
        }
        this.vertRulers.clear();
        this.vertRuler = null;
        for (ItemNode item2 : this.allItems) {
            this.removeNode((INode)item2);
        }
        this.analogItems.clear();
        this.binaryItems.clear();
        this.allItems.clear();
        Bean[] allHistoryItems = this.getHistoryItems();
        int i = 0;
        while (i < this.spec.items.size()) {
            item = this.spec.items.get(i);
            ItemNode node = (ItemNode)this.addNode(ItemNode.class);
            node.setTrendItem((TrendItem)((Object)item), allHistoryItems);
            node.color = JarisPaints.getColor(item.index);
            Bean[] beanArray = node.historyItems;
            int n = node.historyItems.length;
            int n2 = 0;
            while (n2 < n) {
                Bean historyItem = beanArray[n2];
                try {
                    this.itemIds.add((String)historyItem.getField("id"));
                }
                catch (BindingException bindingException) {
                    // empty catch block
                }
                ++n2;
            }
            if (item.renderer == TrendItem.Renderer.Analog) {
                this.analogItems.add(node);
            } else {
                this.binaryItems.add(node);
            }
            this.allItems.add(node);
            ++i;
        }
        boolean bl = this.singleAxis = this.spec.axisMode == YAxisMode.SingleAxis;
        if (!this.analogItems.isEmpty()) {
            if (this.singleAxis) {
                this.vertRuler = (VertRuler)this.addNode("VertRuler", VertRuler.class);
                this.vertRulers.add(this.vertRuler);
                this.vertRuler.manualscale = true;
                i = 0;
                while (i < this.analogItems.size()) {
                    item = this.analogItems.get(i);
                    ((ItemNode)item).ruler = this.vertRuler;
                    ((ItemNode)item).trendNode = this;
                    if (!(((ItemNode)item).item.scale instanceof Scale.Manual)) {
                        this.vertRuler.manualscale = false;
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.analogItems.size()) {
                    item = this.analogItems.get(i);
                    VertRuler vr = (VertRuler)this.addNode("VertRuler" + i, VertRuler.class);
                    vr.color = ((ItemNode)item).color;
                    vr.label = ((ItemNode)item).item.label;
                    ((ItemNode)item).ruler = vr;
                    ((ItemNode)item).trendNode = this;
                    this.vertRulers.add(vr);
                    vr.manualscale = ((ItemNode)item).item.scale instanceof Scale.Manual;
                    ++i;
                }
                this.vertRuler = this.vertRulers.isEmpty() ? null : this.vertRulers.get(this.vertRulerIndex >= 0 && this.vertRulerIndex >= this.vertRulers.size() ? 0 : this.vertRulerIndex);
            }
        }
        TimeWindow tw = this.spec.viewProfile.timeWindow;
        boolean bl2 = this.horizRuler.manualscale = tw.timeWindowLength != null && tw.timeWindowStart != null;
        if (timeWindowChange) {
            this.horizRuler.autoscale();
        }
        this.shapedirty = true;
    }

    public void layout() {
        double aah;
        double bah;
        double w = this.bounds.getWidth();
        double h = this.bounds.getHeight();
        if (this.titleNode != null) {
            this.titleNode.setSize(w, h * 0.02);
            this.titleNode.setTranslate(0.0, 10.0);
            this.titleNode.layout();
        }
        double praw = w - 60.0;
        double ph = h - 20.0 - 20.0 - 26.0;
        if (this.titleNode != null) {
            ph -= this.titleNode.th;
        }
        if (!this.analogItems.isEmpty()) {
            bah = (double)this.binaryItems.size() * BINARY[3];
            aah = Math.max(0.0, ph - bah);
            if (aah + bah > ph) {
                bah = ph - aah;
            }
        } else {
            aah = 0.0;
            bah = ph;
        }
        for (VertRuler vertRuler : this.vertRulers) {
            vertRuler.setHeight(aah);
            vertRuler.layout();
        }
        this.plot.analogAreaHeight = aah;
        this.plot.binaryAreaHeight = bah;
        double vrws = 0.0;
        for (VertRuler vertRuler : this.vertRulers) {
            vrws += vertRuler.getWidth();
        }
        if (!this.binaryItems.isEmpty()) {
            vrws = Math.max(50.0, vrws);
        }
        double pw = praw - vrws;
        this.plot.setTranslate(30.0, (this.titleNode != null ? this.titleNode.th : 0.0) + 10.0 + 20.0);
        this.plot.setSize(pw, ph);
        this.horizRuler.layout();
        this.horizRuler.setTranslate(30.0, this.plot.getY() + this.plot.getHeight() + 3.0);
        boolean l = this.horizRuler.setWidth(pw);
        if (l |= this.horizRuler.setFromEnd(this.horizRuler.from, this.horizRuler.end)) {
            this.horizRuler.layout();
        }
        double vrx = this.plot.getX() + this.plot.getWidth() + 3.0;
        for (VertRuler vertRuler : this.vertRulers) {
            vertRuler.setTranslate(vrx, this.plot.getY());
            vrx += vertRuler.getWidth() + 3.0;
        }
    }

    public void setSize(double width, double height) {
        this.bounds.setFrame(0.0, 0.0, width, height);
    }

    public void render(Graphics2D g2d) {
        QualityHints qh = QualityHints.getQuality((Graphics2D)g2d);
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, this.quality.textQuality == LineQuality.Antialias ? RenderingHints.VALUE_TEXT_ANTIALIAS_ON : RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        Rectangle bounds = g2d.getClipBounds();
        if (bounds.getWidth() != this.bounds.getWidth() || bounds.getHeight() != this.bounds.getHeight()) {
            this.setSize(bounds.getWidth(), bounds.getHeight());
            this.layout();
        }
        this.flushHistory();
        super.render(g2d);
        this.plot.renderValueTip(g2d);
        qh.setQuality(g2d);
    }

    public Rectangle2D getBoundsInLocal() {
        return this.bounds;
    }

    public boolean allPast() {
        boolean fixedWindow;
        TimeWindow timeWindow = this.spec.viewProfile.timeWindow;
        boolean bl = fixedWindow = !this.horizRuler.autoscroll || timeWindow.timeWindowStart != null && timeWindow.timeWindowLength != null;
        if (fixedWindow) {
            for (ItemNode item : this.allItems) {
                if (!(item.end <= this.horizRuler.end)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void flushHistory() {
        if (this.collector == null || !(this.collector instanceof CollectorImpl)) {
            return;
        }
        CollectorImpl fh = (CollectorImpl)this.collector;
        fh.flush(this.itemIds);
    }

    public void readMinMaxFromEnd() {
        this.flushHistory();
        for (ItemNode item : this.allItems) {
            item.readMinMaxFromEnd();
        }
        this.horizRuler.setKnownFromEnd();
        for (VertRuler vertRuler : this.vertRulers) {
            vertRuler.setKnownMinMax();
        }
    }

    public boolean autoscale(boolean timeAxis, boolean valueAxis) {
        if (!timeAxis && !valueAxis) {
            return false;
        }
        this.readMinMaxFromEnd();
        boolean changed = false;
        if (timeAxis && (changed |= this.horizRuler.autoscale()) && !this.printing) {
            this.horizRuler.fireListener();
        }
        if (valueAxis) {
            for (VertRuler vertRuler : this.vertRulers) {
                changed |= vertRuler.autoscale();
            }
        }
        return changed;
    }

    public void zoomIn(double x, double y, double width, double height, boolean horiz, boolean vert) {
        if (horiz) {
            this.horizRuler.zoomIn(x, width);
        }
        if (vert) {
            for (VertRuler vertRuler : this.vertRulers) {
                vertRuler.zoomIn(y, height);
            }
        }
        this.shapedirty = true;
    }

    public void zoomOut() {
        this.horizRuler.zoomOut();
        for (VertRuler vertRuler : this.vertRulers) {
            vertRuler.zoomOut();
        }
        this.shapedirty = true;
    }

    public TrendSpec getTrendSpec() {
        return this.spec;
    }

    public Viewport getViewport() {
        Viewport vp = new Viewport();
        vp.init();
        vp.from = this.horizRuler.from;
        vp.end = this.horizRuler.end;
        for (VertRuler vr : this.vertRulers) {
            Viewport.AxisViewport avp = new Viewport.AxisViewport();
            avp.min = vr.min;
            avp.max = vr.max;
            vp.axesports.add(avp);
        }
        return vp;
    }

    public void setViewport(Viewport vp) {
        this.horizRuler.from = vp.from;
        this.horizRuler.end = vp.end;
        int i = 0;
        for (Viewport.AxisViewport avp : vp.axesports) {
            if (i >= this.vertRulers.size()) break;
            VertRuler vr = this.vertRulers.get(i++);
            vr.min = avp.min;
            vr.max = avp.max;
        }
    }

    public void setQuality(TrendQualitySpec quality) {
        this.quality = quality;
    }

    public TrendQualitySpec getQuality() {
        return this.quality;
    }

    public Double snapToValue(double time, double snapToleranceInTime) throws HistoryException, AccessorException {
        double from = this.horizRuler.from;
        double end = this.horizRuler.end;
        double pixelsPerSecond = (end - from) / this.plot.getWidth();
        TreeSet<Double> values = new TreeSet<Double>((Comparator<Double>)Bindings.DOUBLE);
        for (ItemNode item : this.allItems) {
            Stream s = item.openStream(pixelsPerSecond);
            if (s == null) continue;
            int pos = s.binarySearch((Binding)Bindings.DOUBLE, (Object)time);
            ValueBand vb = new ValueBand((Binding)s.sampleBinding, s.sampleBinding.createDefaultUnchecked());
            if (pos >= 0) {
                return time;
            }
            int prev = -pos - 2;
            int next = -pos - 1;
            int count = s.count();
            Double prevTime = null;
            Double nextTime = null;
            if (prev >= 0 && prev < count) {
                s.accessor.get(prev, (Binding)s.sampleBinding, vb.getSample());
                if (!vb.isNanSample()) {
                    Double nTime;
                    prevTime = vb.getTimeDouble();
                    if (vb.hasEndTime() && (nTime = Double.valueOf(vb.getEndTimeDouble())) != null && nTime + snapToleranceInTime > time) {
                        nextTime = nTime;
                    }
                }
            }
            if (nextTime == null && next >= 0 && next < count) {
                s.accessor.get(next, (Binding)s.sampleBinding, vb.getSample());
                if (!vb.isNanSample()) {
                    nextTime = vb.getTimeDouble();
                }
            }
            if (prevTime == null && nextTime == null) continue;
            if (prevTime == null) {
                if (!(nextTime - time < snapToleranceInTime)) continue;
                values.add(nextTime);
                continue;
            }
            if (nextTime == null) {
                if (!(time - prevTime < snapToleranceInTime)) continue;
                values.add(prevTime);
                continue;
            }
            values.add(nextTime);
            values.add(prevTime);
        }
        if (values.isEmpty()) {
            return null;
        }
        Double lower = values.floor(time);
        Double higher = values.ceiling(time);
        if (lower == null) {
            return higher;
        }
        if (higher == null) {
            return lower;
        }
        double result = time - lower < higher - time ? lower : higher;
        return result;
    }
}

