/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.simantics.databoard.util.Bean;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.chassis.AWTChassis;
import org.simantics.g2d.image.DefaultImages;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.util.subscription.SubscriptionItem;
import org.simantics.simulation.data.Datasource;
import org.simantics.trend.TestData;
import org.simantics.trend.TrendInitializer;
import org.simantics.trend.configuration.Scale;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.trend.configuration.TrendSamplingFormats;
import org.simantics.trend.configuration.TrendSpec;
import org.simantics.trend.configuration.YAxisMode;
import org.simantics.trend.impl.TrendNode;
import org.simantics.trend.impl.TrendParticipant;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;

public class TestSetTrendConfig {
    public static void main(String[] args) throws Exception {
        System.out.println(DefaultImages.HAND);
        final TestData data = new TestData();
        TestSetTrendConfig.addSomeHistoryItems(data.historyManager);
        TrendSpec trendSpec = new TrendSpec();
        trendSpec.init();
        trendSpec.viewProfile.showMilestones = true;
        trendSpec.name = "Multiple Y-Axis DemoTrend";
        trendSpec.axisMode = YAxisMode.MultiAxis;
        trendSpec.items.add(new TrendItem(1, "Sine", data.subscriptionId, "Sine", new Scale.Manual(-1.0, 1.0), TrendItem.Renderer.Analog));
        trendSpec.items.add(new TrendItem(2, "Ramp", data.subscriptionId, "Ramp", new Scale.Manual(-100.0, 100.0), TrendItem.Renderer.Binary));
        trendSpec.items.add(new TrendItem(3, "Random", data.subscriptionId, "Random", new Scale.Auto(), TrendItem.Renderer.Analog));
        trendSpec.viewProfile.profileName = "Profile";
        trendSpec.viewProfile.timeWindow.timeWindowIncrement = 75.0;
        JFrame frame = new JFrame("Demo Trend");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                data.dispose();
                System.exit(0);
            }
        });
        data.solver.start();
        AWTChassis chassis = new AWTChassis();
        chassis.setPreferredSize(new Dimension(480, 320));
        frame.getContentPane().add((Component)chassis, "Center");
        frame.pack();
        frame.setVisible(true);
        chassis.requestFocus();
        IThreadWorkQueue thread = AWTThread.getThreadAccess();
        long startTime = System.currentTimeMillis();
        CanvasContext ctx = TrendInitializer.createDefaultCanvas(thread, data.historyManager, data.collector, (Datasource)data.solver, trendSpec);
        TrendNode node = TrendInitializer.getTrendNode(ctx);
        long endTime = System.currentTimeMillis();
        long elapsedTime = endTime - startTime;
        System.out.println(elapsedTime);
        ((TrendParticipant)((Object)ctx.getAtMostOneItemOfClass(TrendParticipant.class))).setHintAsync(TrendParticipant.KEY_TREND_DRAW_INTERVAL, 1000L);
        IHintContext hintCtx = ctx.getDefaultHintContext();
        chassis.setCanvasContext((ICanvasContext)ctx);
    }

    static void addSomeHistoryItems(HistoryManager history) throws HistoryException {
        String subscriptionId = "abc";
        int i = 0;
        while (i < 2000) {
            SubscriptionItem[] hi = null;
            String id = "id" + i;
            hi = SubscriptionItem.createItems((String)id, (String)subscriptionId, TrendSamplingFormats.createAnalogSamplingFormats(0.0, 0.0, ""));
            history.create((Bean[])hi);
            ++i;
        }
    }
}

