/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend;

import java.io.File;
import java.util.UUID;
import org.simantics.databoard.util.Bean;
import org.simantics.history.Collector;
import org.simantics.history.History;
import org.simantics.history.HistoryException;
import org.simantics.history.HistoryManager;
import org.simantics.history.impl.CollectorImpl;
import org.simantics.history.util.subscription.SubscriptionItem;
import org.simantics.simulation.data.Datasource;
import org.simantics.simulation.data.DatasourceAdapter;
import org.simantics.simulation.data.PseudoSolver;
import org.simantics.trend.configuration.TrendSamplingFormats;
import org.simantics.utils.FileUtils;

public class TestData {
    public PseudoSolver solver;
    public File workarea;
    public HistoryManager historyManager;
    public Collector collector;
    public DatasourceAdapter adapter;
    public String subscriptionId = UUID.randomUUID().toString();

    public TestData() throws HistoryException {
        this.historyManager = History.createMemoryHistory();
        this.collector = new CollectorImpl(this.historyManager);
        this.init();
    }

    public TestData(File workarea) throws HistoryException {
        this.workarea = workarea;
        this.historyManager = History.openFileHistory((File)workarea);
        this.collector = new CollectorImpl(this.historyManager);
        this.init();
    }

    void init() throws HistoryException {
        this.solver = new PseudoSolver();
        SubscriptionItem[] hi = null;
        hi = SubscriptionItem.createItems((String)PseudoSolver.SINE, (String)this.subscriptionId, TrendSamplingFormats.createAnalogSamplingFormats(0.0, 0.0, "m"));
        this.historyManager.create((Bean[])hi);
        this.collector.addItems((Bean[])hi);
        hi = SubscriptionItem.createItems((String)PseudoSolver.RAMP, (String)this.subscriptionId, TrendSamplingFormats.createBinarySamplingFormats(0.0));
        this.historyManager.create((Bean[])hi);
        this.collector.addItems((Bean[])hi);
        hi = SubscriptionItem.createItems((String)PseudoSolver.RANDOM, (String)this.subscriptionId, TrendSamplingFormats.createAnalogSamplingFormats(0.0, 0.0, "j"));
        this.historyManager.create((Bean[])hi);
        this.collector.addItems((Bean[])hi);
        this.adapter = new DatasourceAdapter(this.collector);
        this.solver.addListener((Datasource.DatasourceListener)this.adapter);
    }

    public void dispose() {
        this.solver.removeListener((Datasource.DatasourceListener)this.adapter);
        this.adapter.reset();
        this.solver.stop();
        this.collector.close();
        try {
            SubscriptionItem[] subscriptionItemArray = this.collector.getItems();
            int n = subscriptionItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                SubscriptionItem bean = subscriptionItemArray[n2];
                String id = (String)bean.getFieldUnchecked("id");
                this.historyManager.delete(new String[]{id});
                ++n2;
            }
        }
        catch (HistoryException e) {
            e.printStackTrace();
        }
        this.historyManager.close();
        if (this.workarea != null) {
            FileUtils.deleteDir((File)this.workarea);
        }
    }
}

