/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.JFrame;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.CanvasContext;
import org.simantics.g2d.chassis.AWTChassis;
import org.simantics.g2d.image.DefaultImages;
import org.simantics.history.impl.FileHistory;
import org.simantics.simulation.data.Datasource;
import org.simantics.trend.TestData;
import org.simantics.trend.TrendInitializer;
import org.simantics.trend.configuration.Scale;
import org.simantics.trend.configuration.TrendItem;
import org.simantics.trend.configuration.TrendSpec;
import org.simantics.trend.configuration.YAxisMode;
import org.simantics.trend.impl.Milestone;
import org.simantics.trend.impl.MilestoneSpec;
import org.simantics.trend.impl.TrendNode;
import org.simantics.trend.impl.TrendParticipant;
import org.simantics.utils.FileUtils;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.threads.AWTThread;
import org.simantics.utils.threads.IThreadWorkQueue;

public class DemoTrend {
    public static void main(String[] args) throws Exception {
        System.out.println(DefaultImages.HAND);
        File workarea = FileUtils.createTmpDir();
        final TestData data = new TestData(workarea);
        FileHistory fh = (FileHistory)data.historyManager;
        fh.asyncUsage = false;
        TrendSpec trendSpec = new TrendSpec();
        trendSpec.init();
        trendSpec.viewProfile.showMilestones = true;
        trendSpec.name = "Multiple Y-Axis DemoTrend";
        trendSpec.axisMode = YAxisMode.MultiAxis;
        trendSpec.items.add(new TrendItem(1, "Sine", data.subscriptionId, "Sine", new Scale.Manual(-1.0, 1.0), TrendItem.Renderer.Analog));
        trendSpec.items.add(new TrendItem(2, "Ramp", data.subscriptionId, "Ramp", new Scale.Manual(-100.0, 100.0), TrendItem.Renderer.Binary));
        trendSpec.items.add(new TrendItem(3, "Random", data.subscriptionId, "Random", new Scale.Auto(), TrendItem.Renderer.Analog));
        trendSpec.viewProfile.profileName = "Profile";
        trendSpec.viewProfile.timeWindow.timeWindowIncrement = 75.0;
        JFrame frame = new JFrame("Demo Trend");
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                data.dispose();
                System.exit(0);
            }
        });
        data.solver.start();
        final AWTChassis chassis = new AWTChassis();
        chassis.setPreferredSize(new Dimension(480, 320));
        frame.getContentPane().add((Component)chassis, "Center");
        frame.pack();
        frame.setVisible(true);
        chassis.requestFocus();
        IThreadWorkQueue thread = AWTThread.getThreadAccess();
        final CanvasContext ctx = TrendInitializer.createDefaultCanvas(thread, data.historyManager, data.collector, (Datasource)data.solver, trendSpec);
        TrendNode node = TrendInitializer.getTrendNode(ctx);
        ((TrendParticipant)((Object)ctx.getAtMostOneItemOfClass(TrendParticipant.class))).setHintAsync(TrendParticipant.KEY_TREND_DRAW_INTERVAL, 1000L);
        MilestoneSpec milestones = new MilestoneSpec();
        milestones.init();
        Milestone m1 = new Milestone("1", "1", "Event 1", 50.0);
        Milestone m2 = new Milestone("2", "2", "Event 2", 60.0);
        Milestone m3 = new Milestone("3", "3", "Event 3", 80.0);
        Milestone m4 = new Milestone("4", "4", "Event 4", 90.0);
        milestones.milestones.add(m1);
        milestones.milestones.add(m2);
        milestones.milestones.add(m3);
        milestones.milestones.add(m4);
        milestones.baseline = 2;
        node.setMilestones(milestones);
        IHintContext hintCtx = ctx.getDefaultHintContext();
        thread.asyncExec(new Runnable(){

            @Override
            public void run() {
                chassis.setCanvasContext((ICanvasContext)ctx);
            }
        });
    }
}

