/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.trend;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class DecimalFormatDemo {
    public static void customFormat(String pattern, double value) {
        DecimalFormat myFormatter = new DecimalFormat(pattern);
        String output = myFormatter.format(value);
        System.out.println(String.valueOf(value) + "  " + pattern + "  " + output);
    }

    public static void localizedFormat(String pattern, double value, Locale loc) {
        NumberFormat nf = NumberFormat.getNumberInstance(loc);
        DecimalFormat df = (DecimalFormat)nf;
        df.applyPattern(pattern);
        String output = df.format(value);
        System.out.println(String.valueOf(pattern) + "  " + output + "  " + loc.toString());
    }

    public static void main(String[] args) {
        DecimalFormatDemo.customFormat("###,###.###", 123456.789);
        DecimalFormatDemo.customFormat("###.##", 123456.789);
        DecimalFormatDemo.customFormat("000000.000", 123.78);
        DecimalFormatDemo.customFormat("$###,###.###", 12345.67);
        DecimalFormatDemo.customFormat("\u00a5###,###.###", 12345.67);
        Locale currentLocale = new Locale("en", "US");
        DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols(currentLocale);
        unusualSymbols.setDecimalSeparator('|');
        unusualSymbols.setGroupingSeparator('^');
        String strange = "#,##0.###";
        DecimalFormat weirdFormatter = new DecimalFormat(strange, unusualSymbols);
        weirdFormatter.setGroupingSize(4);
        String bizarre = weirdFormatter.format(12345.678);
        System.out.println(bizarre);
        Locale[] locales = new Locale[]{new Locale("en", "US"), new Locale("de", "DE"), new Locale("fr", "FR")};
        int i = 0;
        while (i < locales.length) {
            DecimalFormatDemo.localizedFormat("###,###.###", 123456.789, locales[i]);
            ++i;
        }
    }
}

