/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.schema;

import gnu.trove.THashMap;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.ILinkType;
import org.simantics.objmap.IMappingSchema;
import org.simantics.objmap.MappingException;
import org.simantics.objmap.schema.SimpleLinkType;

public class SimpleSchema
implements IMappingSchema {
    THashMap<Resource, SimpleLinkType> domainLinkTypes = new THashMap();
    THashMap<Class<?>, SimpleLinkType> rangeLinkTypes = new THashMap();

    public void addLinkType(SimpleLinkType linkType) {
        this.domainLinkTypes.put((Object)linkType.domainType, (Object)linkType);
        this.rangeLinkTypes.put(linkType.rangeType, (Object)linkType);
    }

    @Override
    public ILinkType linkTypeOfDomainElement(ReadGraph g, Resource element) throws MappingException {
        try {
            for (Resource type : g.getTypes(element)) {
                ILinkType linkType = (ILinkType)this.domainLinkTypes.get((Object)type);
                if (linkType == null) continue;
                return linkType;
            }
            throw new MappingException("Didn't find a link type for " + NameUtils.getSafeName((ReadGraph)g, (Resource)element) + ".");
        }
        catch (DatabaseException e) {
            throw new MappingException(e);
        }
    }

    @Override
    public ILinkType linkTypeOfRangeElement(Object element) throws MappingException {
        ILinkType type = (ILinkType)this.rangeLinkTypes.get(element.getClass());
        if (type == null) {
            throw new MappingException("Didn't find a link type for " + element + ".");
        }
        return type;
    }
}

