/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.examples;

import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.IMappingSchema;
import org.simantics.objmap.annotations.GraphType;
import org.simantics.objmap.annotations.RelatedElement;
import org.simantics.objmap.annotations.RelatedElements;
import org.simantics.objmap.annotations.RelatedValue;
import org.simantics.objmap.schema.MappingSchemas;
import org.simantics.objmap.schema.SimpleSchema;

public class SysdynExample {
    public static IMappingSchema createSchema(ReadGraph g) throws DatabaseException, InstantiationException, IllegalAccessException {
        SimpleSchema schema = new SimpleSchema();
        schema.addLinkType(MappingSchemas.fromAnnotations(g, Configuration.class));
        schema.addLinkType(MappingSchemas.fromAnnotations(g, Dependency.class));
        schema.addLinkType(MappingSchemas.fromAnnotations(g, Auxiliary.class));
        return schema;
    }

    @GraphType(value="http://www.simantics.org/Sysdyn-1.1/Auxiliary")
    static class Auxiliary
    extends Variable {
        Auxiliary() {
        }
    }

    static abstract class Component {
        Component() {
        }
    }

    @GraphType(value="http://www.simantics.org/Sysdyn-1.1/Configuration")
    static class Configuration {
        @RelatedElements(value="http://www.simantics.org/Layer0-1.0/ConsistsOf")
        Collection<Component> components;

        Configuration() {
        }
    }

    @GraphType(value="http://www.simantics.org/Sysdyn-1.1/Dependency")
    static class Dependency
    extends Component {
        @RelatedElement(value="http://www.simantics.org/Sysdyn-1.1/HasTail")
        Variable tail;
        @RelatedElement(value="http://www.simantics.org/Sysdyn-1.1/HasHead")
        Auxiliary head;

        Dependency() {
        }
    }

    static abstract class Variable
    extends Component {
        @RelatedValue(value="http://www.simantics.org/Layer0-1.0/HasName")
        String name;

        Variable() {
        }
    }
}

