/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.list;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;

public class ShareableList<T>
extends AbstractList<T> {
    public static final int INITIAL_CAPACITY = 4;
    T[] elements;
    int size;
    boolean head;

    public ShareableList(T[] elements, int size, boolean head) {
        this.elements = elements;
        this.size = size;
        this.head = head;
    }

    public ShareableList() {
        this.elements = new Object[4];
        this.size = 0;
        this.head = true;
    }

    @Override
    public T get(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.elements[index];
    }

    @Override
    public int size() {
        return this.size;
    }

    public ShareableList<T> append(T element) {
        Object[] newElements;
        if (this.size < this.elements.length) {
            if (this.head) {
                this.head = false;
                newElements = this.elements;
            } else {
                newElements = new Object[this.elements.length];
                System.arraycopy(this.elements, 0, newElements, 0, this.size);
            }
        } else {
            newElements = Arrays.copyOf(this.elements, this.elements.length * 3 / 2 + 1);
        }
        newElements[this.size] = element;
        return new ShareableList<Object>(newElements, this.size + 1, true);
    }

    public ShareableList<T> appendAll(List<T> xs) {
        Object[] newElements;
        int size = this.size;
        int count = xs.size();
        int newSize = size + count;
        if (newSize <= this.elements.length) {
            if (this.head) {
                this.head = false;
                newElements = this.elements;
            } else {
                newElements = new Object[this.elements.length];
                System.arraycopy(this.elements, 0, newElements, 0, size);
            }
        } else {
            newElements = Arrays.copyOf(this.elements, Math.max(this.elements.length * 3 / 2 + 1, newSize));
        }
        int i = 0;
        while (i < count) {
            newElements[i + size] = xs.get(i);
            ++i;
        }
        return new ShareableList<Object>(newElements, newSize, true);
    }

    public static <T> List<T> add(List<T> list, T element) {
        ShareableList<Object> result;
        if (list instanceof ShareableList) {
            result = ((ShareableList)list).append(element);
        } else {
            int size = list.size();
            Object[] newElements = new Object[size * 3 / 2 + 1];
            newElements[size] = element;
            result = new ShareableList<Object>(newElements, size + 1, true);
        }
        return result;
    }

    public static <T> List<T> concat(List<T> a, List<T> b) {
        ShareableList<Object> result;
        if (a instanceof ShareableList) {
            result = ((ShareableList)a).appendAll(b);
        } else {
            int aSize = a.size();
            int bSize = b.size();
            int size = aSize + bSize;
            Object[] newElements = new Object[size * 3 / 2 + 1];
            int i = 0;
            while (i < aSize) {
                newElements[i] = a.get(i);
                ++i;
            }
            i = 0;
            while (i < bSize) {
                newElements[aSize + i] = b.get(i);
                ++i;
            }
            result = new ShareableList<Object>(newElements, size, true);
        }
        return result;
    }
}

