/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.chr.queue;

import java.util.Random;

public class IntPriorityQueue {
    int[] data;
    int size;

    public IntPriorityQueue(int maxSize) {
        this.data = new int[maxSize];
    }

    void add(int v) {
        int pos = this.size++;
        while (pos > 0) {
            int parent = pos - 1 >> 1;
            int parentValue = this.data[parent];
            if (parentValue <= v) break;
            this.data[pos] = parentValue;
            pos = parent;
        }
        this.data[pos] = v;
    }

    void remove() {
        int child1;
        int v = this.data[--this.size];
        int pos = 0;
        while ((child1 = 2 * pos + 1) < this.size) {
            int child1Value = this.data[child1];
            if (child1 + 1 < this.size) {
                int child2Value = this.data[child1 + 1];
                if (v <= child1Value) {
                    if (v <= child2Value) break;
                    this.data[pos] = child2Value;
                    pos = child1 + 1;
                    continue;
                }
                if (child1Value < child2Value) {
                    this.data[pos] = child1Value;
                    pos = child1;
                    continue;
                }
                this.data[pos] = child2Value;
                pos = child1 + 1;
                continue;
            }
            if (v <= child1Value) break;
            this.data[pos] = child1Value;
            pos = child1;
        }
        this.data[pos] = v;
    }

    int peek() {
        return this.data[0];
    }

    public boolean isValid() {
        int i = 1;
        while (i < this.size) {
            if (this.data[i] < this.data[i - 1 >> 1]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append('[');
        int i = 0;
        while (i < this.size) {
            if (i > 0) {
                b.append(", ");
            }
            b.append(this.data[i]);
            ++i;
        }
        b.append(']');
        return b.toString();
    }

    public static void main(String[] args) {
        IntPriorityQueue q = new IntPriorityQueue(52);
        Random random = new Random();
        int i = 0;
        while (i < 50) {
            q.add(random.nextInt(100));
            q.add(random.nextInt(100));
            q.remove();
            if (!q.isValid()) {
                System.out.println("NOT VALID:");
                System.out.println(q);
                return;
            }
            ++i;
        }
        System.out.println(q);
    }
}

