/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.scl.runtime.chr.index;

import org.simantics.scl.runtime.chr.index.Constraint;
import org.simantics.scl.runtime.chr.index.IndexEntry;

public class ConstraintIndex {
    public static final float LOAD_FACTOR_LOW = 0.5f;
    public static final float LOAD_FACTOR_HIGH = 0.75f;
    public static final int INITIAL_CAPACITY = 32;
    private IndexEntry[] table = new IndexEntry[32];
    private int size = 0;
    private int capacity = (int)((float)this.table.length * 0.75f);

    public void add(int hash, Constraint constraint) {
        int pos = hash & this.table.length - 1;
        this.table[pos] = new IndexEntry(constraint, hash, this.table[pos]);
        ++this.size;
        if (this.size > this.capacity) {
            this.cleanup();
        }
    }

    public IndexEntry get(int hash) {
        int pos = hash & this.table.length - 1;
        IndexEntry entry = this.table[pos];
        if (entry != null && entry.value.discarded) {
            entry = entry.next;
            while (entry != null && entry.value.discarded) {
                entry = entry.next;
            }
            this.table[pos] = entry;
            IndexEntry cur = this.table[pos];
            while (cur != entry) {
                IndexEntry temp = cur.next;
                cur.next = entry;
                cur = temp;
            }
        }
        while (entry != null && entry.hash != hash) {
            entry = entry.next_();
        }
        return entry;
    }

    private void cleanup() {
        this.size = this.removeDiscarded();
        if ((float)this.size > (float)this.table.length * 0.5f) {
            this.doubleSize();
            this.capacity = (int)((float)this.table.length * 0.75f);
        }
    }

    private void doubleSize() {
        int l = this.table.length;
        IndexEntry[] newTable = new IndexEntry[2 * l];
        int i = 0;
        while (i < l) {
            IndexEntry lowFirst = null;
            IndexEntry lowCur = null;
            IndexEntry highFirst = null;
            IndexEntry highCur = null;
            IndexEntry cur = this.table[i];
            while (cur != null) {
                if ((cur.hash & l) == 0) {
                    if (lowFirst == null) {
                        lowFirst = lowCur = cur;
                        continue;
                    }
                    lowCur.setNext(cur);
                    lowCur = cur;
                    continue;
                }
                if (highFirst == null) {
                    highFirst = highCur = cur;
                    continue;
                }
                highCur.setNext(cur);
                highCur = cur;
            }
            newTable[i] = lowFirst;
            newTable[i + l] = highFirst;
            ++i;
        }
        this.table = newTable;
    }

    private int removeDiscarded() {
        int count = 0;
        int i = 0;
        while (i < this.table.length) {
            IndexEntry entry = this.table[i];
            IndexEntry prev = null;
            while (entry != null) {
                if (entry.value.discarded) {
                    entry = entry.next;
                    if (prev == null) {
                        this.table[i] = entry;
                        continue;
                    }
                    prev.next = entry;
                    continue;
                }
                ++count;
                prev = entry;
                entry = entry.next;
            }
            ++i;
        }
        return count;
    }

    public void print() {
        int i = 0;
        while (i < this.table.length) {
            System.out.print(String.valueOf(i) + ":");
            ConstraintIndex.print(this.table[i]);
            System.out.println();
            ++i;
        }
    }

    private static void print(IndexEntry entry) {
        while (entry != null) {
            System.out.print(' ');
            System.out.print(String.valueOf(entry.hash) + "#" + entry.value.id + (entry.value.discarded ? "(D)" : ""));
            entry = entry.next;
        }
    }
}

