/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.viewport.event;

import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEventHandler;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;

public class ViewportEventHandler
implements ILayerEventHandler<IStructuralChangeEvent> {
    private final ViewportLayer viewportLayer;

    public ViewportEventHandler(ViewportLayer viewportLayer) {
        this.viewportLayer = viewportLayer;
    }

    @Override
    public Class<IStructuralChangeEvent> getLayerEventClass() {
        return IStructuralChangeEvent.class;
    }

    @Override
    public void handleLayerEvent(IStructuralChangeEvent event) {
        Collection<StructuralDiff> rowDiffs;
        if (event.isHorizontalStructureChanged()) {
            this.viewportLayer.invalidateHorizontalStructure();
        }
        if (event.isVerticalStructureChanged()) {
            this.viewportLayer.invalidateVerticalStructure();
        }
        Collection<StructuralDiff> columnDiffs = event.getColumnDiffs();
        IUniqueIndexLayer scrollableLayer = this.viewportLayer.getScrollableLayer();
        if (columnDiffs != null) {
            int columnOffset = 0;
            int minimumOriginColumnPosition = this.viewportLayer.getMinimumOriginColumnPosition();
            if (minimumOriginColumnPosition < 0) {
                minimumOriginColumnPosition = scrollableLayer.getColumnCount();
            }
            for (StructuralDiff columnDiff : columnDiffs) {
                switch (columnDiff.getDiffType()) {
                    case ADD: {
                        Range afterPositionRange = columnDiff.getAfterPositionRange();
                        if (afterPositionRange.start >= minimumOriginColumnPosition) break;
                        columnOffset += afterPositionRange.size();
                        break;
                    }
                    case DELETE: {
                        Range beforePositionRange = columnDiff.getBeforePositionRange();
                        if (beforePositionRange.start >= minimumOriginColumnPosition) break;
                        columnOffset -= Math.min(beforePositionRange.end, minimumOriginColumnPosition + 1) - beforePositionRange.start;
                    }
                }
            }
            this.viewportLayer.setMinimumOriginX(scrollableLayer.getStartXOfColumnPosition(minimumOriginColumnPosition + columnOffset));
        }
        if ((rowDiffs = event.getRowDiffs()) != null) {
            int rowOffset = 0;
            int minimumOriginRowPosition = this.viewportLayer.getMinimumOriginRowPosition();
            if (minimumOriginRowPosition < 0) {
                minimumOriginRowPosition = scrollableLayer.getColumnCount();
            }
            for (StructuralDiff rowDiff : rowDiffs) {
                switch (rowDiff.getDiffType()) {
                    case ADD: {
                        Range afterPositionRange = rowDiff.getAfterPositionRange();
                        if (afterPositionRange.start >= minimumOriginRowPosition) break;
                        rowOffset += afterPositionRange.size();
                        break;
                    }
                    case DELETE: {
                        Range beforePositionRange = rowDiff.getBeforePositionRange();
                        if (beforePositionRange.start >= minimumOriginRowPosition) break;
                        rowOffset -= Math.min(beforePositionRange.end, minimumOriginRowPosition + 1) - beforePositionRange.start;
                    }
                }
            }
            this.viewportLayer.setMinimumOriginY(scrollableLayer.getStartYOfRowPosition(minimumOriginRowPosition + rowOffset));
        }
    }
}

