/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.viewport;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.coordinate.PixelCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.grid.command.ClientAreaResizeCommand;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.print.command.PrintEntireGridCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOffCommand;
import org.eclipse.nebula.widgets.nattable.print.command.TurnViewportOnCommand;
import org.eclipse.nebula.widgets.nattable.selection.ScrollSelectionCommandHandler;
import org.eclipse.nebula.widgets.nattable.selection.command.MoveSelectionCommand;
import org.eclipse.nebula.widgets.nattable.selection.command.ScrollSelectionCommand;
import org.eclipse.nebula.widgets.nattable.selection.event.CellSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.ColumnSelectionEvent;
import org.eclipse.nebula.widgets.nattable.selection.event.RowSelectionEvent;
import org.eclipse.nebula.widgets.nattable.viewport.HorizontalScrollBarHandler;
import org.eclipse.nebula.widgets.nattable.viewport.VerticalScrollBarHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.RecalculateScrollBarsCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ShowCellInViewportCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ShowColumnInViewportCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ShowRowInViewportCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportDragCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportSelectColumnCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.command.ViewportSelectRowCommandHandler;
import org.eclipse.nebula.widgets.nattable.viewport.event.ScrollEvent;
import org.eclipse.nebula.widgets.nattable.viewport.event.ViewportEventHandler;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.ScrollBar;

public class ViewportLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    private HorizontalScrollBarHandler hBarListener;
    private VerticalScrollBarHandler vBarListener;
    private final IUniqueIndexLayer scrollableLayer;
    private PixelCoordinate origin = new PixelCoordinate(0, 0);
    private PixelCoordinate minimumOrigin = new PixelCoordinate(0, 0);
    private int minimumOriginColumnPosition = 0;
    private int minimumOriginRowPosition = 0;
    private boolean viewportOff = false;
    private PixelCoordinate savedOrigin = new PixelCoordinate(0, 0);
    private int cachedColumnCount = -1;
    private int cachedRowCount = -1;
    private int cachedClientAreaWidth = 0;
    private int cachedClientAreaHeight = 0;
    private int cachedWidth = -1;
    private int cachedHeight = -1;
    private ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private Point edgeHoverScrollOffset = new Point(0, 0);
    private ScheduledFuture<?> edgeHoverScrollFuture;

    public ViewportLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
        this.scrollableLayer = underlyingLayer;
        this.registerCommandHandlers();
        this.registerEventHandler(new ViewportEventHandler(this));
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.hBarListener != null) {
            this.hBarListener.dispose();
        }
        if (this.vBarListener != null) {
            this.vBarListener.dispose();
        }
        this.scheduler.shutdown();
    }

    public PixelCoordinate getMinimumOrigin() {
        return this.minimumOrigin;
    }

    public int getMinimumOriginColumnPosition() {
        return this.minimumOriginColumnPosition;
    }

    public int getMinimumOriginRowPosition() {
        return this.minimumOriginRowPosition;
    }

    public void setMinimumOriginX(int newMinimumOriginX) {
        PixelCoordinate previousMinimumOrigin = this.minimumOrigin;
        if (newMinimumOriginX != this.minimumOrigin.getX()) {
            this.minimumOrigin = new PixelCoordinate(newMinimumOriginX, this.minimumOrigin.getY());
            this.minimumOriginColumnPosition = this.scrollableLayer.getColumnPositionByX(this.minimumOrigin.getX());
        }
        int delta = this.minimumOrigin.getX() - previousMinimumOrigin.getX();
        this.setOriginX(this.origin.getX() + delta);
        this.recalculateHorizontalScrollBar();
    }

    public void setMinimumOriginY(int newMinimumOriginY) {
        PixelCoordinate previousMinimumOrigin = this.minimumOrigin;
        if (newMinimumOriginY != this.minimumOrigin.getY()) {
            this.minimumOrigin = new PixelCoordinate(this.minimumOrigin.getX(), newMinimumOriginY);
            this.minimumOriginRowPosition = this.scrollableLayer.getRowPositionByY(this.minimumOrigin.getY());
        }
        int delta = this.minimumOrigin.getY() - previousMinimumOrigin.getY();
        this.setOriginY(this.origin.getY() + delta);
        this.recalculateVerticalScrollBar();
    }

    public void setMinimumOrigin(int newMinimumOriginX, int newMinimumOriginY) {
        this.setMinimumOriginX(newMinimumOriginX);
        this.setMinimumOriginY(newMinimumOriginY);
    }

    public PixelCoordinate getOrigin() {
        return this.viewportOff ? this.minimumOrigin : this.origin;
    }

    private int getOriginColumnPosition() {
        return this.scrollableLayer.getColumnPositionByX(this.getOrigin().getX());
    }

    private int getOriginRowPosition() {
        return this.scrollableLayer.getRowPositionByY(this.getOrigin().getY());
    }

    private int boundsCheckOriginX(int x) {
        int min = this.minimumOrigin.getX();
        if (x <= min) {
            return min;
        }
        int max = Math.max(this.getUnderlyingLayer().getStartXOfColumnPosition(0) + this.getUnderlyingLayer().getWidth(), min);
        if (x > max) {
            return max;
        }
        return x;
    }

    private int boundsCheckOriginY(int y) {
        int min = this.minimumOrigin.getY();
        if (y <= min) {
            return min;
        }
        int max = Math.max(this.getUnderlyingLayer().getStartYOfRowPosition(0) + this.getUnderlyingLayer().getHeight(), min);
        if (y > max) {
            return max;
        }
        return y;
    }

    public void setOriginX(int newOriginX) {
        newOriginX = this.boundsCheckOriginX(newOriginX);
        if ((newOriginX = this.boundsCheckOriginX(this.adjustOriginX(newOriginX))) != this.origin.getX()) {
            this.invalidateHorizontalStructure();
            this.origin = new PixelCoordinate(newOriginX, this.origin.getY());
            this.fireScrollEvent();
        }
    }

    public void setOriginY(int newOriginY) {
        newOriginY = this.boundsCheckOriginY(newOriginY);
        if ((newOriginY = this.boundsCheckOriginY(this.adjustOriginY(newOriginY))) != this.origin.getY()) {
            this.invalidateVerticalStructure();
            this.origin = new PixelCoordinate(this.origin.getX(), newOriginY);
            this.fireScrollEvent();
        }
    }

    public void resetOrigin(int newOriginX, int newOriginY) {
        PixelCoordinate previousOrigin = this.origin;
        this.minimumOrigin = new PixelCoordinate(0, 0);
        this.minimumOriginColumnPosition = 0;
        this.minimumOriginRowPosition = 0;
        this.origin = new PixelCoordinate(newOriginX, newOriginY);
        if (this.origin.getX() != previousOrigin.getX()) {
            this.invalidateHorizontalStructure();
        }
        if (this.origin.getY() != previousOrigin.getY()) {
            this.invalidateVerticalStructure();
        }
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new RecalculateScrollBarsCommandHandler(this));
        this.registerCommandHandler(new ScrollSelectionCommandHandler(this));
        this.registerCommandHandler(new ShowCellInViewportCommandHandler(this));
        this.registerCommandHandler(new ShowColumnInViewportCommandHandler(this));
        this.registerCommandHandler(new ShowRowInViewportCommandHandler(this));
        this.registerCommandHandler(new ViewportSelectColumnCommandHandler(this));
        this.registerCommandHandler(new ViewportSelectRowCommandHandler(this));
        this.registerCommandHandler(new ViewportDragCommandHandler(this));
    }

    @Override
    public int getColumnCount() {
        int availableWidth;
        if (this.viewportOff) {
            return Math.max(this.scrollableLayer.getColumnCount() - this.getMinimumOriginColumnPosition(), 0);
        }
        if (this.cachedColumnCount < 0 && (availableWidth = this.getClientAreaWidth()) >= 0) {
            if (this.origin.getX() < this.minimumOrigin.getX()) {
                this.origin = new PixelCoordinate(this.minimumOrigin.getX(), this.origin.getY());
            }
            this.recalculateAvailableWidthAndColumnCount();
        }
        return this.cachedColumnCount;
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return this.scrollableLayer.getColumnPositionByIndex(columnIndex) - this.getOriginColumnPosition();
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        int underlyingPosition = this.getOriginColumnPosition() + localColumnPosition;
        if (underlyingPosition < this.getMinimumOriginColumnPosition()) {
            return -1;
        }
        return underlyingPosition;
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        if (sourceUnderlyingLayer != this.getUnderlyingLayer()) {
            return -1;
        }
        return underlyingColumnPosition - this.getOriginColumnPosition();
    }

    @Override
    public int getWidth() {
        if (this.viewportOff) {
            return this.scrollableLayer.getWidth() - this.scrollableLayer.getStartXOfColumnPosition(this.getMinimumOriginColumnPosition());
        }
        if (this.cachedWidth < 0) {
            this.recalculateAvailableWidthAndColumnCount();
        }
        return this.cachedWidth;
    }

    @Override
    public int getColumnWidthByPosition(int columnPosition) {
        int width = super.getColumnWidthByPosition(columnPosition);
        return width;
    }

    @Override
    public boolean isColumnPositionResizable(int columnPosition) {
        return this.getUnderlyingLayer().isColumnPositionResizable(this.getOriginColumnPosition() + columnPosition);
    }

    @Override
    public int getColumnPositionByX(int x) {
        return this.getUnderlyingLayer().getColumnPositionByX(this.getOrigin().getX() + x) - this.getOriginColumnPosition();
    }

    @Override
    public int getStartXOfColumnPosition(int columnPosition) {
        return this.getUnderlyingLayer().getStartXOfColumnPosition(this.getOriginColumnPosition() + columnPosition) - this.getOrigin().getX();
    }

    @Override
    public int getRowCount() {
        int availableHeight;
        if (this.viewportOff) {
            return Math.max(this.scrollableLayer.getRowCount() - this.getMinimumOriginRowPosition(), 0);
        }
        if (this.cachedRowCount < 0 && (availableHeight = this.getClientAreaHeight()) >= 0) {
            if (this.origin.getY() < this.minimumOrigin.getY()) {
                this.origin = new PixelCoordinate(this.origin.getX(), this.minimumOrigin.getY());
            }
            this.recalculateAvailableHeightAndRowCount();
        }
        return this.cachedRowCount;
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        return this.scrollableLayer.getRowPositionByIndex(rowIndex) - this.getOriginRowPosition();
    }

    @Override
    public int localToUnderlyingRowPosition(int localRowPosition) {
        int underlyingPosition = this.getOriginRowPosition() + localRowPosition;
        if (underlyingPosition < this.getMinimumOriginRowPosition()) {
            return -1;
        }
        return underlyingPosition;
    }

    @Override
    public int underlyingToLocalRowPosition(ILayer sourceUnderlyingLayer, int underlyingRowPosition) {
        if (sourceUnderlyingLayer != this.getUnderlyingLayer()) {
            return -1;
        }
        return underlyingRowPosition - this.getOriginRowPosition();
    }

    @Override
    public int getHeight() {
        if (this.viewportOff) {
            return this.scrollableLayer.getHeight() - this.scrollableLayer.getStartYOfRowPosition(this.getMinimumOriginRowPosition());
        }
        if (this.cachedHeight < 0) {
            this.recalculateAvailableHeightAndRowCount();
        }
        return this.cachedHeight;
    }

    @Override
    public int getRowHeightByPosition(int rowPosition) {
        int height = super.getRowHeightByPosition(rowPosition);
        return height;
    }

    @Override
    public int getRowPositionByY(int y) {
        return this.getUnderlyingLayer().getRowPositionByY(this.getOrigin().getY() + y) - this.getOriginRowPosition();
    }

    @Override
    public int getStartYOfRowPosition(int rowPosition) {
        return this.getUnderlyingLayer().getStartYOfRowPosition(this.getOriginRowPosition() + rowPosition) - this.getOrigin().getY();
    }

    @Override
    public Rectangle getBoundsByPosition(int columnPosition, int rowPosition) {
        int underlyingColumnPosition = this.localToUnderlyingColumnPosition(columnPosition);
        int underlyingRowPosition = this.localToUnderlyingRowPosition(rowPosition);
        Rectangle bounds = this.getUnderlyingLayer().getBoundsByPosition(underlyingColumnPosition, underlyingRowPosition);
        bounds.x -= this.getOrigin().getX();
        bounds.y -= this.getOrigin().getY();
        return bounds;
    }

    public void invalidateHorizontalStructure() {
        this.cachedColumnCount = -1;
        this.cachedClientAreaWidth = 0;
        this.cachedWidth = -1;
    }

    public void invalidateVerticalStructure() {
        this.cachedRowCount = -1;
        this.cachedClientAreaHeight = 0;
        this.cachedHeight = -1;
    }

    protected void recalculateAvailableWidthAndColumnCount() {
        int availableWidth = this.getClientAreaWidth();
        int originColumnPosition = this.getOriginColumnPosition();
        if (originColumnPosition >= 0) {
            availableWidth += this.getOrigin().getX() - this.underlyingLayer.getStartXOfColumnPosition(originColumnPosition);
        }
        ILayer underlyingLayer = this.getUnderlyingLayer();
        this.cachedWidth = 0;
        this.cachedColumnCount = 0;
        int columnPosition = originColumnPosition;
        while (columnPosition >= 0 && columnPosition < underlyingLayer.getColumnCount() && availableWidth > 0) {
            int width = underlyingLayer.getColumnWidthByPosition(columnPosition);
            availableWidth -= width;
            this.cachedWidth += width;
            ++this.cachedColumnCount;
            ++columnPosition;
        }
        int checkedOriginX = this.boundsCheckOriginX(this.origin.getX());
        if (checkedOriginX != this.origin.getX()) {
            this.origin = new PixelCoordinate(checkedOriginX, this.origin.getY());
        }
    }

    protected void recalculateAvailableHeightAndRowCount() {
        int availableHeight = this.getClientAreaHeight();
        int originRowPosition = this.getOriginRowPosition();
        if (originRowPosition >= 0) {
            availableHeight += this.getOrigin().getY() - this.underlyingLayer.getStartYOfRowPosition(originRowPosition);
        }
        ILayer underlyingLayer = this.getUnderlyingLayer();
        this.cachedHeight = 0;
        this.cachedRowCount = 0;
        int rowPosition = this.getOriginRowPosition();
        while (rowPosition >= 0 && rowPosition < underlyingLayer.getRowCount() && availableHeight > 0) {
            int height = underlyingLayer.getRowHeightByPosition(rowPosition);
            availableHeight -= height;
            this.cachedHeight += height;
            ++this.cachedRowCount;
            ++rowPosition;
        }
        int checkedOriginY = this.boundsCheckOriginY(this.origin.getY());
        if (checkedOriginY != this.origin.getY()) {
            this.origin = new PixelCoordinate(this.origin.getY(), checkedOriginY);
        }
    }

    public void moveCellPositionIntoViewport(int scrollableColumnPosition, int scrollableRowPosition) {
        this.moveColumnPositionIntoViewport(scrollableColumnPosition);
        this.moveRowPositionIntoViewport(scrollableRowPosition);
    }

    public void moveColumnPositionIntoViewport(int scrollableColumnPosition) {
        ILayer underlyingLayer = this.getUnderlyingLayer();
        if (underlyingLayer.getColumnIndexByPosition(scrollableColumnPosition) >= 0 && scrollableColumnPosition >= this.getMinimumOriginColumnPosition()) {
            int originColumnPosition = this.getOriginColumnPosition();
            if (scrollableColumnPosition <= originColumnPosition) {
                this.setOriginX(this.scrollableLayer.getStartXOfColumnPosition(scrollableColumnPosition));
            } else {
                int scrollableColumnStartX = underlyingLayer.getStartXOfColumnPosition(scrollableColumnPosition);
                int scrollableColumnEndX = scrollableColumnStartX + underlyingLayer.getColumnWidthByPosition(scrollableColumnPosition);
                int clientAreaWidth = this.getClientAreaWidth();
                int viewportEndX = underlyingLayer.getStartXOfColumnPosition(this.getOriginColumnPosition()) + clientAreaWidth;
                if (viewportEndX < scrollableColumnEndX) {
                    this.setOriginX(Math.min(scrollableColumnEndX - clientAreaWidth, scrollableColumnStartX));
                }
            }
            this.adjustHorizontalScrollBar();
        }
    }

    public void moveRowPositionIntoViewport(int scrollableRowPosition) {
        ILayer underlyingLayer = this.getUnderlyingLayer();
        if (underlyingLayer.getRowIndexByPosition(scrollableRowPosition) >= 0 && scrollableRowPosition >= this.getMinimumOriginRowPosition()) {
            int originRowPosition = this.getOriginRowPosition();
            if (scrollableRowPosition <= originRowPosition) {
                this.setOriginY(this.scrollableLayer.getStartYOfRowPosition(scrollableRowPosition));
            } else {
                int scrollableRowStartY = underlyingLayer.getStartYOfRowPosition(scrollableRowPosition);
                int scrollableRowEndY = scrollableRowStartY + underlyingLayer.getRowHeightByPosition(scrollableRowPosition);
                int clientAreaHeight = this.getClientAreaHeight();
                int viewportEndY = underlyingLayer.getStartYOfRowPosition(this.getOriginRowPosition()) + clientAreaHeight;
                if (viewportEndY < scrollableRowEndY) {
                    this.setOriginY(Math.min(scrollableRowEndY - clientAreaHeight, scrollableRowStartY));
                }
            }
            this.adjustVerticalScrollBar();
        }
    }

    protected void fireScrollEvent() {
        this.fireLayerEvent(new ScrollEvent(this));
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof ClientAreaResizeCommand && command.convertToTargetLayer(this)) {
            ClientAreaResizeCommand clientAreaResizeCommand = (ClientAreaResizeCommand)command;
            int widthDiff = clientAreaResizeCommand.getScrollable().getClientArea().width - clientAreaResizeCommand.getCalcArea().width;
            int heightDiff = clientAreaResizeCommand.getScrollable().getClientArea().height - clientAreaResizeCommand.getCalcArea().height;
            ScrollBar hBar = clientAreaResizeCommand.getScrollable().getHorizontalBar();
            ScrollBar vBar = clientAreaResizeCommand.getScrollable().getVerticalBar();
            if (this.hBarListener == null && hBar != null) {
                this.hBarListener = new HorizontalScrollBarHandler(this, hBar);
            }
            if (this.vBarListener == null && vBar != null) {
                this.vBarListener = new VerticalScrollBarHandler(this, vBar);
            }
            this.handleGridResize();
            Rectangle possibleArea = clientAreaResizeCommand.getScrollable().getClientArea();
            possibleArea.width -= widthDiff;
            possibleArea.height -= heightDiff;
            clientAreaResizeCommand.setCalcArea(possibleArea);
        } else {
            if (command instanceof TurnViewportOffCommand) {
                this.savedOrigin = this.origin;
                this.viewportOff = true;
                return true;
            }
            if (command instanceof TurnViewportOnCommand) {
                this.viewportOff = false;
                this.origin = this.savedOrigin;
                return true;
            }
            if (command instanceof PrintEntireGridCommand) {
                this.moveCellPositionIntoViewport(0, 0);
            }
        }
        return super.doCommand(command);
    }

    private void recalculateHorizontalScrollBar() {
        if (this.hBarListener != null) {
            this.hBarListener.recalculateScrollBarSize();
            if (!this.hBarListener.scrollBar.getEnabled()) {
                this.setOriginX(0);
            }
        }
    }

    private void recalculateVerticalScrollBar() {
        if (this.vBarListener != null) {
            this.vBarListener.recalculateScrollBarSize();
            if (!this.vBarListener.scrollBar.getEnabled()) {
                this.setOriginY(0);
            }
        }
    }

    public void recalculateScrollBars() {
        this.recalculateHorizontalScrollBar();
        this.recalculateVerticalScrollBar();
    }

    protected void handleGridResize() {
        this.setOriginX(this.origin.getX());
        this.recalculateHorizontalScrollBar();
        this.setOriginY(this.origin.getY());
        this.recalculateVerticalScrollBar();
    }

    protected int adjustOriginX(int originX) {
        if (this.getColumnCount() == 0) {
            return 0;
        }
        int availableWidth = this.getClientAreaWidth() - (this.scrollableLayer.getWidth() - originX);
        if (availableWidth <= 0) {
            return originX;
        }
        return this.boundsCheckOriginX(originX - availableWidth);
    }

    protected int adjustOriginY(int originY) {
        if (this.getRowCount() == 0) {
            return 0;
        }
        int availableHeight = this.getClientAreaHeight() - (this.scrollableLayer.getHeight() - originY);
        if (availableHeight <= 0) {
            return originY;
        }
        return this.boundsCheckOriginY(originY - availableHeight);
    }

    public void scrollVerticallyByAPage(ScrollSelectionCommand scrollSelectionCommand) {
        this.getUnderlyingLayer().doCommand(this.scrollVerticallyByAPageCommand(scrollSelectionCommand));
    }

    protected MoveSelectionCommand scrollVerticallyByAPageCommand(ScrollSelectionCommand scrollSelectionCommand) {
        return new MoveSelectionCommand(scrollSelectionCommand.getDirection(), this.getRowCount(), scrollSelectionCommand.isShiftMask(), scrollSelectionCommand.isControlMask());
    }

    protected boolean isLastColumnCompletelyDisplayed() {
        int lastDisplayableColumnIndex = this.getUnderlyingLayer().getColumnIndexByPosition(this.getUnderlyingLayer().getColumnCount() - 1);
        int visibleColumnCount = this.getColumnCount();
        int lastVisibleColumnIndex = this.getColumnIndexByPosition(visibleColumnCount - 1);
        return lastVisibleColumnIndex == lastDisplayableColumnIndex && this.getClientAreaWidth() >= this.getWidth();
    }

    protected boolean isLastRowCompletelyDisplayed() {
        int lastDisplayableRowIndex = this.getUnderlyingLayer().getRowIndexByPosition(this.getUnderlyingLayer().getRowCount() - 1);
        int visibleRowCount = this.getRowCount();
        int lastVisibleRowIndex = this.getRowIndexByPosition(visibleRowCount - 1);
        return lastVisibleRowIndex == lastDisplayableRowIndex && this.getClientAreaHeight() >= this.getHeight();
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof IStructuralChangeEvent) {
            IStructuralChangeEvent structuralChangeEvent = (IStructuralChangeEvent)event;
            if (structuralChangeEvent.isHorizontalStructureChanged()) {
                this.invalidateHorizontalStructure();
            }
            if (structuralChangeEvent.isVerticalStructureChanged()) {
                this.invalidateVerticalStructure();
            }
        }
        if (event instanceof CellSelectionEvent) {
            this.processSelection((CellSelectionEvent)event);
        } else if (event instanceof ColumnSelectionEvent) {
            this.processColumnSelection((ColumnSelectionEvent)event);
        } else if (event instanceof RowSelectionEvent) {
            this.processRowSelection((RowSelectionEvent)event);
        }
        super.handleLayerEvent(event);
    }

    private void processSelection(CellSelectionEvent selectionEvent) {
        this.moveCellPositionIntoViewport(selectionEvent.getColumnPosition(), selectionEvent.getRowPosition());
        this.adjustHorizontalScrollBar();
        this.adjustVerticalScrollBar();
    }

    private void processColumnSelection(ColumnSelectionEvent selectionEvent) {
        for (Range columnPositionRange : selectionEvent.getColumnPositionRanges()) {
            this.moveColumnPositionIntoViewport(columnPositionRange.end - 1);
            this.adjustHorizontalScrollBar();
        }
    }

    private void processRowSelection(RowSelectionEvent selectionEvent) {
        int rowPositionToMoveIntoViewport = selectionEvent.getRowPositionToMoveIntoViewport();
        if (rowPositionToMoveIntoViewport >= 0) {
            this.moveRowPositionIntoViewport(rowPositionToMoveIntoViewport);
            this.adjustVerticalScrollBar();
        }
    }

    private void adjustHorizontalScrollBar() {
        if (this.hBarListener != null) {
            this.hBarListener.adjustScrollBar();
        }
    }

    private void adjustVerticalScrollBar() {
        if (this.vBarListener != null) {
            this.vBarListener.adjustScrollBar();
        }
    }

    public int getClientAreaWidth() {
        int clientAreaWidth = this.getClientAreaProvider().getClientArea().width;
        if (clientAreaWidth != this.cachedClientAreaWidth) {
            this.invalidateHorizontalStructure();
            this.cachedClientAreaWidth = clientAreaWidth;
        }
        return this.cachedClientAreaWidth;
    }

    public int getClientAreaHeight() {
        int clientAreaHeight = this.getClientAreaProvider().getClientArea().height;
        if (clientAreaHeight != this.cachedClientAreaHeight) {
            this.invalidateVerticalStructure();
            this.cachedClientAreaHeight = clientAreaHeight;
        }
        return this.cachedClientAreaHeight;
    }

    public IUniqueIndexLayer getScrollableLayer() {
        return this.scrollableLayer;
    }

    @Override
    public String toString() {
        return "Viewport Layer";
    }

    public void drag(int x, int y) {
        this.edgeHoverScrollOffset.x = 0;
        this.edgeHoverScrollOffset.y = 0;
        if (x < 0 && y < 0) {
            this.cancelEdgeHoverScroll();
            return;
        }
        Rectangle clientArea = this.getClientAreaProvider().getClientArea();
        int minX = clientArea.x;
        int maxX = clientArea.x + clientArea.width;
        if (x >= minX && x < minX + 10) {
            this.edgeHoverScrollOffset.x = -1;
        } else if (x > maxX - 10 && x < maxX) {
            this.edgeHoverScrollOffset.x = 1;
        }
        int minY = clientArea.y;
        int maxY = clientArea.y + clientArea.height;
        if (y >= minY && y < minY + 10) {
            this.edgeHoverScrollOffset.y = -1;
        } else if (y > maxY - 10 && y < maxY) {
            this.edgeHoverScrollOffset.y = 1;
        }
        if (this.edgeHoverScrollOffset.x != 0 || this.edgeHoverScrollOffset.y != 0) {
            if (this.edgeHoverScrollFuture == null || this.edgeHoverScrollFuture.isDone()) {
                this.edgeHoverScrollFuture = this.scheduler.schedule(new MoveViewportRunnable(), 500L, TimeUnit.MILLISECONDS);
            }
        } else {
            this.cancelEdgeHoverScroll();
        }
    }

    private void cancelEdgeHoverScroll() {
        this.edgeHoverScrollOffset.x = 0;
        this.edgeHoverScrollOffset.y = 0;
        if (this.edgeHoverScrollFuture != null) {
            this.edgeHoverScrollFuture.cancel(false);
            this.edgeHoverScrollFuture = null;
        }
    }

    class MoveViewportRunnable
    implements Runnable {
        MoveViewportRunnable() {
        }

        @Override
        public void run() {
            if (((ViewportLayer)ViewportLayer.this).edgeHoverScrollOffset.x != 0 || ((ViewportLayer)ViewportLayer.this).edgeHoverScrollOffset.y != 0) {
                ViewportLayer.this.setOriginX(ViewportLayer.this.getUnderlyingLayer().getStartXOfColumnPosition(ViewportLayer.this.getOriginColumnPosition() + ((ViewportLayer)ViewportLayer.this).edgeHoverScrollOffset.x));
                ViewportLayer.this.setOriginY(ViewportLayer.this.getUnderlyingLayer().getStartYOfRowPosition(ViewportLayer.this.getOriginRowPosition() + ((ViewportLayer)ViewportLayer.this).edgeHoverScrollOffset.y));
                ViewportLayer.this.edgeHoverScrollFuture = ViewportLayer.this.scheduler.schedule(new MoveViewportRunnable(), 100L, TimeUnit.MILLISECONDS);
            }
        }
    }
}

