/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.viewport;

import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ScrollBarHandlerTemplate;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public class VerticalScrollBarHandler
extends ScrollBarHandlerTemplate
implements Listener {
    public VerticalScrollBarHandler(ViewportLayer viewportLayer, ScrollBar scrollBar) {
        super(viewportLayer, scrollBar);
    }

    @Override
    int getViewportOrigin() {
        return this.viewportLayer.getOrigin().getY();
    }

    @Override
    int getViewportMinimumOrigin() {
        return this.viewportLayer.getMinimumOrigin().getY();
    }

    @Override
    void setViewportOrigin(int y) {
        this.viewportLayer.setOriginY(y);
    }

    @Override
    SelectionLayer.MoveDirectionEnum scrollDirectionForEventDetail(int eventDetail) {
        return eventDetail == 0x1000005 || eventDetail == 0x1000001 ? SelectionLayer.MoveDirectionEnum.UP : SelectionLayer.MoveDirectionEnum.DOWN;
    }

    @Override
    boolean keepScrolling() {
        return !this.viewportLayer.isLastRowCompletelyDisplayed();
    }

    @Override
    int getViewportWindowSpan() {
        return this.viewportLayer.getClientAreaHeight();
    }

    @Override
    int getScrollableLayerSpan() {
        return this.scrollableLayer.getHeight();
    }

    @Override
    int getScrollIncrement() {
        return this.viewportLayer.getRowCount() > 0 ? this.viewportLayer.getRowHeightByPosition(0) : 0;
    }
}

