/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.viewport;

import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;

public abstract class ScrollBarHandlerTemplate
implements Listener {
    public static final int DEFAULT_OFFSET = 1;
    protected final ViewportLayer viewportLayer;
    protected final IUniqueIndexLayer scrollableLayer;
    protected final ScrollBar scrollBar;
    private boolean dragging = false;

    public ScrollBarHandlerTemplate(ViewportLayer viewportLayer, ScrollBar scrollBar) {
        this.viewportLayer = viewportLayer;
        this.scrollableLayer = viewportLayer.getScrollableLayer();
        this.scrollBar = scrollBar;
        this.scrollBar.addListener(13, (Listener)this);
    }

    public void dispose() {
        if (this.scrollBar != null && !this.scrollBar.isDisposed()) {
            this.scrollBar.removeListener(13, (Listener)this);
        }
    }

    public void handleEvent(Event event) {
        boolean handle = true;
        if (!this.dragging && !EditUtils.commitAndCloseActiveEditor()) {
            handle = false;
        }
        this.dragging = event.detail == 1;
        if (handle) {
            ScrollBar scrollBar = (ScrollBar)event.widget;
            this.setViewportOrigin(this.getViewportMinimumOrigin() + scrollBar.getSelection());
            this.setScrollIncrement();
        } else {
            this.adjustScrollBar();
        }
    }

    void adjustScrollBar() {
        if (this.scrollBar.isDisposed()) {
            return;
        }
        int startPixel = this.getViewportOrigin() - this.getViewportMinimumOrigin();
        this.scrollBar.setSelection(startPixel);
    }

    void recalculateScrollBarSize() {
        int thumbSize;
        int viewportWindowSpan;
        if (this.scrollBar.isDisposed()) {
            return;
        }
        int max = this.getScrollableLayerSpan() - this.getViewportMinimumOrigin();
        if (!this.scrollBar.isDisposed()) {
            this.scrollBar.setMaximum(max);
        }
        if ((viewportWindowSpan = this.getViewportWindowSpan()) < max && viewportWindowSpan != 0) {
            thumbSize = viewportWindowSpan;
            this.scrollBar.setEnabled(true);
            this.scrollBar.setVisible(true);
            this.setScrollIncrement();
            this.scrollBar.setPageIncrement(viewportWindowSpan);
        } else {
            thumbSize = max;
            this.scrollBar.setEnabled(false);
            this.scrollBar.setVisible(false);
        }
        this.scrollBar.setThumb(thumbSize);
        this.adjustScrollBar();
    }

    void setScrollIncrement() {
        int scrollIncrement = Math.min(this.getScrollIncrement(), this.getViewportWindowSpan() / 4);
        this.scrollBar.setIncrement(scrollIncrement);
    }

    abstract int getViewportWindowSpan();

    abstract int getScrollableLayerSpan();

    abstract boolean keepScrolling();

    abstract int getViewportOrigin();

    abstract int getViewportMinimumOrigin();

    abstract void setViewportOrigin(int var1);

    abstract SelectionLayer.MoveDirectionEnum scrollDirectionForEventDetail(int var1);

    abstract int getScrollIncrement();
}

