/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.mode;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.edit.command.EditUtils;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.nebula.widgets.nattable.ui.action.DragModeEventHandler;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.action.IMouseAction;
import org.eclipse.nebula.widgets.nattable.ui.mode.AbstractModeEventHandler;
import org.eclipse.nebula.widgets.nattable.ui.mode.ModeSupport;
import org.eclipse.nebula.widgets.nattable.ui.util.CancelableRunnable;
import org.eclipse.swt.events.MouseEvent;

public class MouseModeEventHandler
extends AbstractModeEventHandler {
    private final NatTable natTable;
    private MouseEvent initialMouseDownEvent;
    private IMouseAction singleClickAction;
    private IMouseAction doubleClickAction;
    private boolean mouseDown;
    private IDragMode dragMode;
    private SingleClickRunnable singleClickRunnable;
    private boolean doubleClick;

    public MouseModeEventHandler(ModeSupport modeSupport, NatTable natTable, MouseEvent initialMouseDownEvent, IMouseAction singleClickAction, IMouseAction doubleClickAction, IDragMode dragMode) {
        super(modeSupport);
        this.natTable = natTable;
        this.mouseDown = true;
        this.initialMouseDownEvent = initialMouseDownEvent;
        this.singleClickAction = singleClickAction;
        this.doubleClickAction = doubleClickAction;
        this.dragMode = dragMode;
    }

    @Override
    public void mouseUp(MouseEvent event) {
        this.mouseDown = false;
        this.doubleClick = false;
        if (this.singleClickAction != null) {
            if (EditUtils.commitAndCloseActiveEditor()) {
                if (this.doubleClickAction != null) {
                    this.singleClickRunnable = new SingleClickRunnable(this.singleClickAction, event);
                    event.display.timerExec(event.display.getDoubleClickTime(), (Runnable)this.singleClickRunnable);
                } else {
                    this.executeSingleClickAction(this.singleClickAction, event);
                }
            }
        } else {
            this.switchMode("NORMAL_MODE");
        }
    }

    @Override
    public void mouseDoubleClick(MouseEvent event) {
        this.doubleClick = true;
        if (EditUtils.commitAndCloseActiveEditor() && this.doubleClickAction != null) {
            event.data = NatEventData.createInstanceFromEvent(event);
            this.doubleClickAction.run(this.natTable, event);
            this.switchMode("NORMAL_MODE");
        }
    }

    @Override
    public synchronized void mouseMove(MouseEvent event) {
        if (this.mouseDown && this.dragMode != null) {
            if (EditUtils.commitAndCloseActiveEditor()) {
                this.dragMode.mouseDown(this.natTable, this.initialMouseDownEvent);
                this.switchMode(new DragModeEventHandler(this.getModeSupport(), this.natTable, this.dragMode));
            } else {
                this.switchMode("NORMAL_MODE");
            }
        } else {
            this.switchMode("NORMAL_MODE");
        }
    }

    private void executeSingleClickAction(IMouseAction action, MouseEvent event) {
        if (EditUtils.commitAndCloseActiveEditor()) {
            event.data = NatEventData.createInstanceFromEvent(event);
            action.run(this.natTable, event);
            this.switchMode("NORMAL_MODE");
        }
    }

    class SingleClickRunnable
    extends CancelableRunnable {
        private IMouseAction action;
        private MouseEvent event;

        public SingleClickRunnable(IMouseAction action, MouseEvent event) {
            this.action = action;
            this.event = event;
        }

        @Override
        public void run() {
            if (!MouseModeEventHandler.this.doubleClick) {
                MouseModeEventHandler.this.executeSingleClickAction(this.action, this.event);
            }
        }
    }
}

