/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.ui.menu;

import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractUiBindingConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.binding.UiBindingRegistry;
import org.eclipse.nebula.widgets.nattable.ui.matcher.MouseEventMatcher;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuAction;
import org.eclipse.nebula.widgets.nattable.ui.menu.PopupMenuBuilder;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Menu;

public class AbstractHeaderMenuConfiguration
extends AbstractUiBindingConfiguration {
    private Menu colHeaderMenu;
    private Menu rowHeaderMenu;
    private Menu cornerMenu;

    public AbstractHeaderMenuConfiguration(NatTable natTable) {
        this.colHeaderMenu = this.createColumnHeaderMenu(natTable).build();
        this.rowHeaderMenu = this.createRowHeaderMenu(natTable).build();
        this.cornerMenu = this.createCornerMenu(natTable).build();
        natTable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AbstractHeaderMenuConfiguration.this.colHeaderMenu != null) {
                    AbstractHeaderMenuConfiguration.this.colHeaderMenu.dispose();
                }
                if (AbstractHeaderMenuConfiguration.this.rowHeaderMenu != null) {
                    AbstractHeaderMenuConfiguration.this.rowHeaderMenu.dispose();
                }
                if (AbstractHeaderMenuConfiguration.this.cornerMenu != null) {
                    AbstractHeaderMenuConfiguration.this.cornerMenu.dispose();
                }
            }
        });
    }

    protected PopupMenuBuilder createColumnHeaderMenu(NatTable natTable) {
        return new PopupMenuBuilder(natTable);
    }

    protected PopupMenuBuilder createRowHeaderMenu(NatTable natTable) {
        return new PopupMenuBuilder(natTable);
    }

    protected PopupMenuBuilder createCornerMenu(NatTable natTable) {
        return new PopupMenuBuilder(natTable);
    }

    @Override
    public void configureUiBindings(UiBindingRegistry uiBindingRegistry) {
        if (this.colHeaderMenu != null) {
            uiBindingRegistry.registerMouseDownBinding(new MouseEventMatcher(0, "COLUMN_HEADER", 3), new PopupMenuAction(this.colHeaderMenu));
        }
        if (this.rowHeaderMenu != null) {
            uiBindingRegistry.registerMouseDownBinding(new MouseEventMatcher(0, "ROW_HEADER", 3), new PopupMenuAction(this.rowHeaderMenu));
        }
        if (this.cornerMenu != null) {
            uiBindingRegistry.registerMouseDownBinding(new MouseEventMatcher(0, "CORNER", 3), new PopupMenuAction(this.cornerMenu));
        }
    }
}

