/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.tree;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractRowHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiRowHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.command.RowHideCommand;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowRowPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.BackgroundPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.tree.ITreeRowModel;
import org.eclipse.nebula.widgets.nattable.tree.command.TreeExpandCollapseCommandHandler;
import org.eclipse.nebula.widgets.nattable.tree.config.DefaultTreeLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.tree.painter.IndentedTreeImagePainter;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;

public class TreeLayer
extends AbstractRowHideShowLayer {
    public static final String TREE_COLUMN_CELL = "TREE_COLUMN_CELL";
    public static final int TREE_COLUMN_NUMBER = 0;
    private final ITreeRowModel<?> treeRowModel;
    private final Set<Integer> hiddenRowIndexes;
    private IndentedTreeImagePainter indentedTreeImagePainter;

    public TreeLayer(IUniqueIndexLayer underlyingLayer, ITreeRowModel<?> treeRowModel) {
        this(underlyingLayer, treeRowModel, new IndentedTreeImagePainter(treeRowModel));
    }

    public TreeLayer(IUniqueIndexLayer underlyingLayer, ITreeRowModel<?> treeRowModel, IndentedTreeImagePainter indentedTreeImagePainter) {
        this(underlyingLayer, treeRowModel, indentedTreeImagePainter, true);
    }

    public TreeLayer(IUniqueIndexLayer underlyingLayer, ITreeRowModel<?> treeRowModel, boolean useDefaultConfiguration) {
        this(underlyingLayer, treeRowModel, new IndentedTreeImagePainter(treeRowModel), useDefaultConfiguration);
    }

    public TreeLayer(IUniqueIndexLayer underlyingLayer, ITreeRowModel<?> treeRowModel, IndentedTreeImagePainter indentedTreeImagePainter, boolean useDefaultConfiguration) {
        super(underlyingLayer);
        this.treeRowModel = treeRowModel;
        this.hiddenRowIndexes = new TreeSet<Integer>();
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultTreeLayerConfiguration(this));
        }
        this.setConfigLabelAccumulator(new IConfigLabelAccumulator(){

            @Override
            public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
                if (TreeLayer.this.isTreeColumn(columnPosition)) {
                    configLabels.addLabelOnTop(TreeLayer.TREE_COLUMN_CELL);
                }
            }
        });
        this.indentedTreeImagePainter = indentedTreeImagePainter;
        this.registerCommandHandler(new TreeExpandCollapseCommandHandler(this));
    }

    public ITreeRowModel<?> getModel() {
        return this.treeRowModel;
    }

    public IndentedTreeImagePainter getIndentedTreeImagePainter() {
        return this.indentedTreeImagePainter;
    }

    public ICellPainter getTreeImagePainter() {
        return this.indentedTreeImagePainter != null ? this.indentedTreeImagePainter.getTreeImagePainter() : null;
    }

    private boolean isTreeColumn(int columnPosition) {
        return columnPosition == 0;
    }

    @Override
    public ICellPainter getCellPainter(int columnPosition, int rowPosition, ILayerCell cell, IConfigRegistry configRegistry) {
        ICellPainter cellPainter = super.getCellPainter(columnPosition, rowPosition, cell, configRegistry);
        if (cell.getConfigLabels().hasLabel(TREE_COLUMN_CELL)) {
            cellPainter = new BackgroundPainter(new CellPainterDecorator(cellPainter, CellEdgeEnum.LEFT, this.indentedTreeImagePainter));
        }
        return cellPainter;
    }

    @Override
    public boolean isRowIndexHidden(int rowIndex) {
        return this.hiddenRowIndexes.contains(rowIndex) || this.isHiddenInUnderlyingLayer(rowIndex);
    }

    @Override
    public Collection<Integer> getHiddenRowIndexes() {
        return this.hiddenRowIndexes;
    }

    public void expandOrCollapseIndex(int parentIndex) {
        if (this.treeRowModel.isCollapsed(parentIndex)) {
            this.expandTreeRow(parentIndex);
        } else {
            this.collapseTreeRow(parentIndex);
        }
    }

    public void collapseTreeRow(int parentIndex) {
        List<Integer> rowIndexes = this.treeRowModel.collapse(parentIndex);
        ArrayList<Integer> rowPositions = new ArrayList<Integer>();
        for (Integer rowIndex : rowIndexes) {
            int rowPos = this.getRowPositionByIndex(rowIndex);
            if (rowPos < 0) continue;
            rowPositions.add(rowPos);
        }
        this.hiddenRowIndexes.addAll(rowIndexes);
        this.invalidateCache();
        this.fireLayerEvent(new HideRowPositionsEvent((ILayer)this, (Collection<Integer>)rowPositions));
    }

    public void expandTreeRow(int parentIndex) {
        List<Integer> rowIndexes = this.treeRowModel.expand(parentIndex);
        int i = rowIndexes.size() - 1;
        while (i >= 0) {
            this.hiddenRowIndexes.remove(rowIndexes.get(i));
            --i;
        }
        this.invalidateCache();
        this.fireLayerEvent(new ShowRowPositionsEvent((ILayer)this, (Collection<Integer>)rowIndexes));
    }

    private boolean isHiddenInUnderlyingLayer(int rowIndex) {
        IUniqueIndexLayer underlyingLayer = (IUniqueIndexLayer)this.getUnderlyingLayer();
        return underlyingLayer.getRowPositionByIndex(rowIndex) == -1;
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        if (command instanceof RowHideCommand) {
            return this.handleRowHideCommand((RowHideCommand)command);
        }
        if (command instanceof MultiRowHideCommand) {
            return this.handleMultiRowHideCommand((MultiRowHideCommand)command);
        }
        return super.doCommand(command);
    }

    protected boolean handleRowHideCommand(RowHideCommand command) {
        int rowIndex;
        if (command.convertToTargetLayer(this) && this.treeRowModel.hasChildren(rowIndex = this.getRowIndexByPosition(command.getRowPosition())) && !this.treeRowModel.isCollapsed(rowIndex)) {
            List<Integer> childIndexes = this.treeRowModel.getChildIndexes(rowIndex);
            int[] childPositions = new int[childIndexes.size() + 1];
            childPositions[0] = command.getRowPosition();
            int i = 1;
            while (i < childIndexes.size() + 1) {
                int childPos;
                childPositions[i] = childPos = this.getRowPositionByIndex(childIndexes.get(i - 1));
                ++i;
            }
            return super.doCommand(new MultiRowHideCommand((ILayer)this, childPositions));
        }
        return super.doCommand(command);
    }

    protected boolean handleMultiRowHideCommand(MultiRowHideCommand command) {
        if (command.convertToTargetLayer(this)) {
            ArrayList<Integer> rowPositionsToHide = new ArrayList<Integer>();
            for (Integer rowPos : command.getRowPositions()) {
                rowPositionsToHide.add(rowPos);
                int rowIndex = this.getRowIndexByPosition(rowPos);
                if (!this.treeRowModel.hasChildren(rowIndex) || this.treeRowModel.isCollapsed(rowIndex)) continue;
                List<Integer> childIndexes = this.treeRowModel.getChildIndexes(rowIndex);
                for (Integer childIndex : childIndexes) {
                    rowPositionsToHide.add(this.getRowPositionByIndex(childIndex));
                }
            }
            int[] childPositions = new int[rowPositionsToHide.size()];
            int i = 0;
            while (i < rowPositionsToHide.size()) {
                childPositions[i] = (Integer)rowPositionsToHide.get(i);
                ++i;
            }
            return super.doCommand(new MultiRowHideCommand((ILayer)this, childPositions));
        }
        return super.doCommand(command);
    }
}

