/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.summaryrow;

import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.summaryrow.ISummaryProvider;

public class SummationSummaryProvider
implements ISummaryProvider {
    private final IDataProvider dataProvider;
    private final boolean strict;

    public SummationSummaryProvider(IDataProvider dataProvider) {
        this(dataProvider, true);
    }

    public SummationSummaryProvider(IDataProvider dataProvider, boolean strict) {
        this.dataProvider = dataProvider;
        this.strict = strict;
    }

    @Override
    public Object summarize(int columnIndex) {
        int rowCount = this.dataProvider.getRowCount();
        float summaryValue = 0.0f;
        int rowIndex = 0;
        while (rowIndex < rowCount) {
            Object dataValue = this.dataProvider.getDataValue(columnIndex, rowIndex);
            if (dataValue instanceof Number) {
                summaryValue += Float.parseFloat(dataValue.toString());
            } else if (this.strict) {
                return DEFAULT_SUMMARY_VALUE;
            }
            ++rowIndex;
        }
        return Float.valueOf(summaryValue);
    }
}

