/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.summaryrow;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IVisualChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.RowUpdateEvent;
import org.eclipse.nebula.widgets.nattable.resize.command.RowResizeCommand;
import org.eclipse.nebula.widgets.nattable.summaryrow.DefaultSummaryRowConfiguration;
import org.eclipse.nebula.widgets.nattable.summaryrow.ISummaryProvider;
import org.eclipse.nebula.widgets.nattable.summaryrow.SummaryRowConfigAttributes;
import org.eclipse.nebula.widgets.nattable.util.ArrayUtil;

public class SummaryRowLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    public static final String DEFAULT_SUMMARY_ROW_CONFIG_LABEL = "SummaryRow";
    public static final String DEFAULT_SUMMARY_COLUMN_CONFIG_LABEL_PREFIX = "SummaryColumn_";
    private final IConfigRegistry configRegistry;
    private int summaryRowHeight = 20;
    protected Map<Integer, Object> summaryCache = new HashMap<Integer, Object>();
    protected Map<Integer, Object> summaryCacheIncludingStaleValues = new HashMap<Integer, Object>();

    public SummaryRowLayer(IUniqueIndexLayer underlyingDataLayer, IConfigRegistry configRegistry) {
        this(underlyingDataLayer, configRegistry, true);
    }

    public SummaryRowLayer(IUniqueIndexLayer underlyingDataLayer, IConfigRegistry configRegistry, boolean autoConfigure) {
        super(underlyingDataLayer);
        this.configRegistry = configRegistry;
        if (autoConfigure) {
            this.addConfiguration(new DefaultSummaryRowConfiguration());
        }
    }

    @Override
    public Object getDataValueByPosition(int columnPosition, int rowPosition) {
        if (this.isSummaryRowPosition(rowPosition)) {
            Object potentiallyStaleSummaryValue = this.getPotentiallyStaleSummaryFromCache(columnPosition);
            if (potentiallyStaleSummaryValue == null || !this.hasNonStaleSummaryFor(columnPosition)) {
                this.calculateNewSummaryValue(potentiallyStaleSummaryValue, columnPosition, rowPosition);
            }
            if (potentiallyStaleSummaryValue != null) {
                return potentiallyStaleSummaryValue;
            }
            return null;
        }
        return super.getDataValueByPosition(columnPosition, rowPosition);
    }

    private void calculateNewSummaryValue(final Object potentiallyStaleSummaryValue, final int columnPosition, final int rowPosition) {
        LabelStack labelStack = this.getConfigLabelsByPosition(columnPosition, rowPosition);
        String[] configLabels = labelStack.getLabels().toArray(ArrayUtil.STRING_TYPE_ARRAY);
        final ISummaryProvider summaryProvider = this.configRegistry.getConfigAttribute(SummaryRowConfigAttributes.SUMMARY_PROVIDER, "NORMAL", configLabels);
        if (summaryProvider == ISummaryProvider.NONE) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                Object summaryValue = SummaryRowLayer.this.calculateColumnSummary(columnPosition, summaryProvider);
                SummaryRowLayer.this.addToCache(columnPosition, summaryValue);
                if (!ObjectUtils.equals((Object)potentiallyStaleSummaryValue, (Object)summaryValue)) {
                    SummaryRowLayer.this.fireLayerEvent(new RowUpdateEvent((ILayer)SummaryRowLayer.this, rowPosition));
                }
            }
        }.start();
    }

    private Object calculateColumnSummary(int columnIndex, ISummaryProvider summaryProvider) {
        Object summaryValue = null;
        if (summaryProvider != null) {
            summaryValue = summaryProvider.summarize(columnIndex);
        }
        return summaryValue;
    }

    public Object getSummaryFromCache(Integer columnIndex) {
        return this.summaryCache.get(columnIndex);
    }

    public Object getPotentiallyStaleSummaryFromCache(Integer columnIndex) {
        return this.summaryCacheIncludingStaleValues.get(columnIndex);
    }

    public boolean hasNonStaleSummaryFor(Integer columnIndex) {
        return this.summaryCache.containsKey(columnIndex);
    }

    protected boolean addToCache(Integer columnIndex, Object summaryValue) {
        Object oldSummaryValue = this.summaryCache.put(columnIndex, summaryValue);
        this.summaryCacheIncludingStaleValues.put(columnIndex, summaryValue);
        return !ObjectUtils.equals((Object)oldSummaryValue, (Object)summaryValue);
    }

    protected void clearSummaryCache() {
        this.summaryCache.clear();
    }

    @Override
    public boolean doCommand(ILayerCommand command) {
        RowResizeCommand rowResizeCommand;
        if (command instanceof RowResizeCommand && this.isSummaryRowPosition((rowResizeCommand = (RowResizeCommand)command).getRowPosition())) {
            this.summaryRowHeight = rowResizeCommand.getNewHeight();
            return true;
        }
        return super.doCommand(command);
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        if (event instanceof IVisualChangeEvent) {
            this.clearSummaryCache();
        }
        super.handleLayerEvent(event);
    }

    @Override
    public LabelStack getConfigLabelsByPosition(int columnPosition, int rowPosition) {
        if (this.isSummaryRowPosition(rowPosition)) {
            return new LabelStack(DEFAULT_SUMMARY_COLUMN_CONFIG_LABEL_PREFIX + columnPosition, DEFAULT_SUMMARY_ROW_CONFIG_LABEL);
        }
        return super.getConfigLabelsByPosition(columnPosition, rowPosition);
    }

    @Override
    public ILayerCell getCellByPosition(int columnPosition, int rowPosition) {
        if (this.isSummaryRowPosition(rowPosition)) {
            return new LayerCell(this, columnPosition, rowPosition);
        }
        return super.getCellByPosition(columnPosition, rowPosition);
    }

    @Override
    public int getHeight() {
        return super.getHeight() + this.getRowHeightByPosition(this.getSummaryRowPosition());
    }

    @Override
    public int getPreferredHeight() {
        return super.getPreferredHeight() + this.getRowHeightByPosition(this.getSummaryRowPosition());
    }

    @Override
    public int getRowCount() {
        return super.getRowCount() + 1;
    }

    @Override
    public int getPreferredRowCount() {
        return this.getRowCount();
    }

    @Override
    public int getRowIndexByPosition(int rowPosition) {
        if (this.isSummaryRowPosition(rowPosition)) {
            return rowPosition;
        }
        return super.getRowIndexByPosition(rowPosition);
    }

    @Override
    public int getRowPositionByY(int y) {
        return LayerUtil.getRowPositionByY(this, y);
    }

    private boolean isSummaryRowPosition(int rowPosition) {
        return rowPosition == this.getSummaryRowPosition();
    }

    private int getSummaryRowPosition() {
        return this.getRowCount() - 1;
    }

    @Override
    public int getRowHeightByPosition(int rowPosition) {
        if (this.isSummaryRowPosition(rowPosition)) {
            return this.summaryRowHeight;
        }
        return super.getRowHeightByPosition(rowPosition);
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        if (rowIndex >= 0 && rowIndex < this.getRowCount()) {
            return rowIndex;
        }
        return -1;
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.getColumnCount()) {
            return columnIndex;
        }
        return -1;
    }
}

