/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.style;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.style.IDisplayModeOrdering;

public class DefaultDisplayModeOrdering
implements IDisplayModeOrdering {
    private static final List<String> NORMAL_ORDERING = Arrays.asList("NORMAL");
    private static final List<String> SELECT_ORDERING = Arrays.asList("SELECT", "NORMAL");
    private static final List<String> EDIT_ORDERING = Arrays.asList("EDIT", "NORMAL");
    private static final List<String> EMPTY_ORDERING = Collections.emptyList();

    @Override
    public List<String> getDisplayModeOrdering(String targetDisplayMode) {
        if ("NORMAL".equals(targetDisplayMode)) {
            return NORMAL_ORDERING;
        }
        if ("SELECT".equals(targetDisplayMode)) {
            return SELECT_ORDERING;
        }
        if ("EDIT".equals(targetDisplayMode)) {
            return EDIT_ORDERING;
        }
        return EMPTY_ORDERING;
    }
}

