/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.sort.painter;

import org.apache.commons.lang.StringUtils;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Image;

public class SortableHeaderTextPainter
extends CellPainterWrapper {
    public SortableHeaderTextPainter() {
        this(new TextPainter());
    }

    public SortableHeaderTextPainter(ICellPainter interiorPainter) {
        this(interiorPainter, CellEdgeEnum.RIGHT);
    }

    public SortableHeaderTextPainter(ICellPainter interiorPainter, CellEdgeEnum cellEdge) {
        this(interiorPainter, cellEdge, new SortIconPainter(true));
    }

    public SortableHeaderTextPainter(ICellPainter interiorPainter, CellEdgeEnum cellEdge, ICellPainter decoratorPainter) {
        this.setWrappedPainter(new CellPainterDecorator(interiorPainter, cellEdge, decoratorPainter));
    }

    public SortableHeaderTextPainter(ICellPainter interiorPainter, CellEdgeEnum cellEdge, boolean paintBg, int spacing, boolean paintDecorationDependent) {
        SortIconPainter sortPainter = new SortIconPainter(paintBg);
        CellPainterDecorator painter = new CellPainterDecorator(interiorPainter, cellEdge, spacing, sortPainter, paintDecorationDependent);
        this.setWrappedPainter(painter);
    }

    public SortableHeaderTextPainter(ICellPainter interiorPainter, boolean paintBg, boolean interiorPainterToSpanFullWidth) {
        SortIconPainter sortPainter = new SortIconPainter(paintBg);
        CellPainterDecorator painter = new CellPainterDecorator(interiorPainter, CellEdgeEnum.RIGHT, 0, sortPainter);
        painter.setPaintDecorationDependent(!interiorPainterToSpanFullWidth);
        this.setWrappedPainter(painter);
    }

    protected static class SortIconPainter
    extends ImagePainter {
        public SortIconPainter(boolean paintBg) {
            super(null, paintBg);
        }

        @Override
        protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
            Image icon = null;
            if (this.isSortedAscending(cell)) {
                icon = this.selectUpImage(this.getSortSequence(cell));
            } else if (this.isSortedDescending(cell)) {
                icon = this.selectDownImage(this.getSortSequence(cell));
            }
            return icon;
        }

        private boolean isSortedAscending(ILayerCell cell) {
            return cell.getConfigLabels().hasLabel("SORT_UP");
        }

        private boolean isSortedDescending(ILayerCell cell) {
            return cell.getConfigLabels().hasLabel("SORT_DOWN");
        }

        private int getSortSequence(ILayerCell cell) {
            int sortSeq = 0;
            for (String configLabel : cell.getConfigLabels().getLabels()) {
                if (!configLabel.startsWith("SORT_SEQ_")) continue;
                String[] tokens = StringUtils.split((String)configLabel, (String)"_");
                sortSeq = Integer.valueOf(tokens[tokens.length - 1]);
            }
            return sortSeq;
        }

        private Image selectUpImage(int sortSequence) {
            switch (sortSequence) {
                case 0: {
                    return GUIHelper.getImage("up_0");
                }
                case 1: {
                    return GUIHelper.getImage("up_1");
                }
                case 2: {
                    return GUIHelper.getImage("up_2");
                }
            }
            return GUIHelper.getImage("up_2");
        }

        private Image selectDownImage(int sortSequence) {
            switch (sortSequence) {
                case 0: {
                    return GUIHelper.getImage("down_0");
                }
                case 1: {
                    return GUIHelper.getImage("down_1");
                }
                case 2: {
                    return GUIHelper.getImage("down_2");
                }
            }
            return GUIHelper.getImage("down_2");
        }
    }
}

