/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection.event;

import java.util.Collection;
import java.util.Set;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEventHandler;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.selection.ISelectionModel;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.swt.graphics.Rectangle;

public class SelectionLayerStructuralChangeEventHandler
implements ILayerEventHandler<IStructuralChangeEvent> {
    private ISelectionModel selectionModel;
    private final SelectionLayer selectionLayer;

    public SelectionLayerStructuralChangeEventHandler(SelectionLayer selectionLayer, ISelectionModel selectionModel) {
        this.selectionLayer = selectionLayer;
        this.selectionModel = selectionModel;
    }

    @Override
    public Class<IStructuralChangeEvent> getLayerEventClass() {
        return IStructuralChangeEvent.class;
    }

    @Override
    public void handleLayerEvent(IStructuralChangeEvent event) {
        event.isHorizontalStructureChanged();
        if (event.isVerticalStructureChanged()) {
            Collection<Rectangle> rectangles = event.getChangedPositionRectangles();
            for (Rectangle rectangle : rectangles) {
                Range changedRange = new Range(rectangle.y, rectangle.y + rectangle.height);
                if (!this.selectedRowModified(changedRange)) continue;
                this.selectionLayer.clear();
                break;
            }
        }
    }

    private boolean selectedRowModified(Range changedRange) {
        Set<Range> selectedRows = this.selectionModel.getSelectedRowPositions();
        for (Range rowRange : selectedRows) {
            if (!rowRange.overlap(changedRange)) continue;
            return true;
        }
        return false;
    }

    public void setSelectionModel(ISelectionModel selectionModel) {
        this.selectionModel = selectionModel;
    }
}

