/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.selection;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.layer.GridLineCellLayerPainter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class SelectionLayerPainter
extends GridLineCellLayerPainter {
    private int columnPositionOffset;
    private int rowPositionOffset;
    private Map<Point, ILayerCell> cells;

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configRegistry) {
        Rectangle previousCellBounds;
        Rectangle currentCellBounds;
        ILayerCell currentCell;
        ILayerCell previousCell;
        Rectangle positionRectangle = this.getPositionRectangleFromPixelRectangle(natLayer, pixelRectangle);
        this.columnPositionOffset = positionRectangle.x;
        this.rowPositionOffset = positionRectangle.y;
        this.cells = new HashMap<Point, ILayerCell>();
        super.paintLayer(natLayer, gc, xOffset, yOffset, pixelRectangle, configRegistry);
        int originalLineStyle = gc.getLineStyle();
        Color originalForeground = gc.getForeground();
        gc.setLineStyle(6);
        gc.setLineDash(new int[]{1, 1});
        gc.setForeground(GUIHelper.COLOR_BLACK);
        boolean selectedMode = false;
        int columnPosition = this.columnPositionOffset;
        while (columnPosition < this.columnPositionOffset + positionRectangle.width) {
            previousCell = null;
            currentCell = null;
            int rowPosition = this.rowPositionOffset;
            while (rowPosition < this.rowPositionOffset + positionRectangle.height) {
                currentCell = this.cells.get(new Point(columnPosition, rowPosition));
                if (currentCell != null && selectedMode != this.isSelected(currentCell)) {
                    selectedMode = !selectedMode;
                    currentCellBounds = currentCell.getBounds();
                    int x0 = xOffset + currentCellBounds.x - 1;
                    int x1 = xOffset + currentCellBounds.x + currentCellBounds.width - 1;
                    int y = yOffset + currentCellBounds.y - 1;
                    if (previousCell != null) {
                        previousCellBounds = previousCell.getBounds();
                        x0 = Math.max(x0, xOffset + previousCellBounds.x - 1);
                        x1 = Math.min(x1, xOffset + previousCellBounds.x + previousCellBounds.width - 1);
                    }
                    gc.drawLine(x0, y, x1, y);
                }
                previousCell = currentCell;
                ++rowPosition;
            }
            if (selectedMode && currentCell != null) {
                Rectangle cellBounds = currentCell.getBounds();
                gc.drawLine(xOffset + cellBounds.x - 1, yOffset + cellBounds.y + cellBounds.height - 1, xOffset + cellBounds.x + cellBounds.width - 1, yOffset + cellBounds.y + cellBounds.height - 1);
            }
            selectedMode = false;
            ++columnPosition;
        }
        int rowPosition = this.rowPositionOffset;
        while (rowPosition < this.rowPositionOffset + positionRectangle.height) {
            previousCell = null;
            currentCell = null;
            int columnPosition2 = this.columnPositionOffset;
            while (columnPosition2 < this.columnPositionOffset + positionRectangle.width) {
                currentCell = this.cells.get(new Point(columnPosition2, rowPosition));
                if (currentCell != null && selectedMode != this.isSelected(currentCell)) {
                    selectedMode = !selectedMode;
                    currentCellBounds = currentCell.getBounds();
                    int x = xOffset + currentCellBounds.x - 1;
                    int y0 = yOffset + currentCellBounds.y - 1;
                    int y1 = yOffset + currentCellBounds.y + currentCellBounds.height - 1;
                    if (previousCell != null) {
                        previousCellBounds = previousCell.getBounds();
                        y0 = Math.max(y0, yOffset + previousCellBounds.y - 1);
                        y1 = Math.min(y1, yOffset + previousCellBounds.y + previousCellBounds.height - 1);
                    }
                    gc.drawLine(x, y0, x, y1);
                }
                previousCell = currentCell;
                ++columnPosition2;
            }
            if (selectedMode && currentCell != null) {
                Rectangle cellBounds = currentCell.getBounds();
                gc.drawLine(xOffset + cellBounds.x + cellBounds.width - 1, yOffset + cellBounds.y - 1, xOffset + cellBounds.x + cellBounds.width - 1, yOffset + cellBounds.y + cellBounds.height - 1);
            }
            selectedMode = false;
            ++rowPosition;
        }
        gc.setLineStyle(originalLineStyle);
        gc.setForeground(originalForeground);
    }

    @Override
    protected void paintCell(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        int columnPosition = cell.getOriginColumnPosition();
        while (columnPosition < cell.getOriginColumnPosition() + cell.getColumnSpan()) {
            int rowPosition = cell.getOriginRowPosition();
            while (rowPosition < cell.getOriginRowPosition() + cell.getRowSpan()) {
                this.cells.put(new Point(columnPosition, rowPosition), cell);
                ++rowPosition;
            }
            ++columnPosition;
        }
        super.paintCell(cell, gc, configRegistry);
    }

    private boolean isSelected(ILayerCell cell) {
        return cell.getDisplayMode() == "SELECT";
    }
}

