/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.search.strategy;

import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.search.strategy.AbstractSearchStrategy;
import org.eclipse.nebula.widgets.nattable.search.strategy.CellDisplayValueSearchUtil;

public class RowSearchStrategy
extends AbstractSearchStrategy {
    private final IConfigRegistry configRegistry;
    private final int[] rowPositions;
    private final String searchDirection;

    public RowSearchStrategy(int[] rowPositions, IConfigRegistry configRegistry) {
        this(rowPositions, configRegistry, "forward");
    }

    public RowSearchStrategy(int[] rowPositions, IConfigRegistry configRegistry, String searchDirection) {
        this.rowPositions = rowPositions;
        this.configRegistry = configRegistry;
        this.searchDirection = searchDirection;
    }

    @Override
    public PositionCoordinate executeSearch(Object valueToMatch) {
        return CellDisplayValueSearchUtil.findCell(this.getContextLayer(), this.configRegistry, this.getRowCellsToSearch(this.getContextLayer()), valueToMatch, this.getComparator(), this.isCaseSensitive());
    }

    protected PositionCoordinate[] getRowCellsToSearch(ILayer contextLayer) {
        ArrayList<PositionCoordinate> cellsToSearch = new ArrayList<PositionCoordinate>();
        int[] nArray = this.rowPositions;
        int n = this.rowPositions.length;
        int n2 = 0;
        while (n2 < n) {
            int rowPosition = nArray[n2];
            cellsToSearch.addAll(CellDisplayValueSearchUtil.getCellCoordinates(this.getContextLayer(), 0, rowPosition, contextLayer.getColumnCount(), 1));
            ++n2;
        }
        if (this.searchDirection.equals("backwards")) {
            Collections.reverse(cellsToSearch);
        }
        return cellsToSearch.toArray(new PositionCoordinate[0]);
    }
}

