/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.search.strategy;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.search.strategy.AbstractSearchStrategy;
import org.eclipse.nebula.widgets.nattable.search.strategy.ColumnSearchStrategy;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;

public class GridSearchStrategy
extends AbstractSearchStrategy {
    private final IConfigRegistry configRegistry;

    public GridSearchStrategy(IConfigRegistry configRegistry, boolean wrapSearch) {
        this(configRegistry, wrapSearch, "forward");
    }

    public GridSearchStrategy(IConfigRegistry configRegistry, boolean wrapSearch, String searchDirection) {
        this.configRegistry = configRegistry;
        this.wrapSearch = wrapSearch;
        this.searchDirection = searchDirection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public PositionCoordinate executeSearch(Object valueToMatch) {
        int startingRowPosition;
        int rowPosition;
        ILayer contextLayer = this.getContextLayer();
        if (!(contextLayer instanceof SelectionLayer)) {
            throw new RuntimeException("For the GridSearchStrategy to work it needs the selectionLayer to be passed as the contextLayer.");
        }
        SelectionLayer selectionLayer = (SelectionLayer)contextLayer;
        PositionCoordinate selectionAnchor = selectionLayer.getSelectionAnchor();
        boolean hadSelectionAnchor = true;
        if (selectionAnchor.columnPosition < 0 || selectionAnchor.rowPosition < 0) {
            selectionAnchor.columnPosition = 0;
            selectionAnchor.rowPosition = 0;
            hadSelectionAnchor = false;
        }
        int anchorColumnPosition = selectionAnchor.columnPosition;
        int[] columnsToSearch = null;
        int columnCount = selectionLayer.getColumnCount();
        if (this.searchDirection.equals("forward")) {
            int rowCount;
            int n = rowPosition = hadSelectionAnchor ? selectionAnchor.rowPosition + 1 : selectionAnchor.rowPosition;
            if (rowPosition > contextLayer.getRowCount() - 1) {
                rowPosition = this.wrapSearch ? 0 : contextLayer.getRowCount() - 1;
            }
            int n2 = startingRowPosition = rowPosition < (rowCount = selectionLayer.getRowCount()) ? rowPosition : 0;
            if (selectionAnchor.rowPosition + 1 >= rowCount && anchorColumnPosition + 1 >= columnCount && hadSelectionAnchor) {
                if (!this.wrapSearch) return null;
                anchorColumnPosition = 0;
            } else if (selectionAnchor.rowPosition == rowCount - 1 && anchorColumnPosition < columnCount - 1) {
                ++anchorColumnPosition;
            }
            columnsToSearch = this.getColumnsToSearchArray(columnCount, anchorColumnPosition);
            return this.searchGrid(valueToMatch, contextLayer, selectionLayer, anchorColumnPosition, startingRowPosition, columnsToSearch);
        } else {
            rowPosition = selectionAnchor.rowPosition - 1;
            if (rowPosition < 0) {
                rowPosition = this.wrapSearch ? contextLayer.getRowCount() - 1 : 0;
            }
            int n = startingRowPosition = rowPosition > 0 ? rowPosition : 0;
            if (selectionAnchor.rowPosition - 1 < 0 && anchorColumnPosition - 1 < 0 && hadSelectionAnchor) {
                if (!this.wrapSearch) return null;
                anchorColumnPosition = columnCount - 1;
            } else if (selectionAnchor.rowPosition == 0 && anchorColumnPosition > 0) {
                --anchorColumnPosition;
            }
            columnsToSearch = this.getDescendingColumnsToSearchArray(anchorColumnPosition);
        }
        return this.searchGrid(valueToMatch, contextLayer, selectionLayer, anchorColumnPosition, startingRowPosition, columnsToSearch);
    }

    private PositionCoordinate searchGrid(Object valueToMatch, ILayer contextLayer, SelectionLayer selectionLayer, int anchorColumnPosition, int startingRowPosition, int[] columnsToSearch) {
        ColumnSearchStrategy columnSearcher = new ColumnSearchStrategy(columnsToSearch, startingRowPosition, this.configRegistry, this.searchDirection);
        columnSearcher.setCaseSensitive(this.caseSensitive);
        columnSearcher.setWrapSearch(this.wrapSearch);
        columnSearcher.setContextLayer(contextLayer);
        columnSearcher.setComparator(this.getComparator());
        PositionCoordinate executeSearch = columnSearcher.executeSearch(valueToMatch);
        if (executeSearch == null && this.wrapSearch) {
            if (this.searchDirection.equals("forward")) {
                columnSearcher.setColumnPositions(this.getColumnsToSearchArray(anchorColumnPosition + 1, 0));
            } else {
                columnSearcher.setColumnPositions(this.getDescendingColumnsToSearchArray(anchorColumnPosition));
            }
            columnSearcher.setStartingRowPosition(0);
            executeSearch = columnSearcher.executeSearch(valueToMatch);
        }
        return executeSearch;
    }

    protected int[] getColumnsToSearchArray(int columnCount, int startingColumnPosition) {
        int numberOfColumnsToSearch = columnCount - startingColumnPosition;
        int[] columnPositions = new int[numberOfColumnsToSearch];
        int columnPosition = 0;
        while (columnPosition < numberOfColumnsToSearch) {
            columnPositions[columnPosition] = startingColumnPosition + columnPosition;
            ++columnPosition;
        }
        return columnPositions;
    }

    protected int[] getDescendingColumnsToSearchArray(int startingColumnPosition) {
        int[] columnPositions = new int[startingColumnPosition + 1];
        int columnPosition = 0;
        while (startingColumnPosition >= 0) {
            columnPositions[columnPosition] = startingColumnPosition--;
            ++columnPosition;
        }
        return columnPositions;
    }
}

