/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.search.gui;

import java.util.Comparator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayerListener;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.search.command.SearchCommand;
import org.eclipse.nebula.widgets.nattable.search.event.SearchEvent;
import org.eclipse.nebula.widgets.nattable.search.strategy.ISearchStrategy;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SearchDialog
extends Dialog {
    private Text findText;
    private Button findButton;
    private Button caseSensitiveButton;
    private Label statusLabel;
    private Button wrapSearchButton;
    private Button forwardButton;
    private final ILayer layer;
    private ISearchStrategy searchStrategy;
    private Comparator<?> comparator;

    private SearchDialog(Shell shell, ILayer layer) {
        super(shell);
        this.layer = layer;
        this.setShellStyle(2144);
        this.setBlockOnOpen(false);
    }

    public static SearchDialog createDialog(Shell shell, ILayer layer) {
        return new SearchDialog(shell, layer);
    }

    public void setSearchStrategy(ISearchStrategy searchStrategy, Comparator<?> comparator) {
        this.searchStrategy = searchStrategy;
        this.comparator = comparator;
    }

    public void create() {
        super.create();
        this.getShell().setText(Messages.getString("Search.find"));
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, false).applyTo((Control)this.createInputPanel(composite));
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)this.createOptionsPanel(composite));
        Composite buttonPanel = this.createButtonSection(composite);
        GridDataFactory.swtDefaults().align(4, 1024).grab(true, true).applyTo((Control)buttonPanel);
        return composite;
    }

    private Composite createButtonSection(Composite composite) {
        Composite panel = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, false);
        panel.setLayout((Layout)layout);
        this.statusLabel = new Label(panel, 16384);
        this.statusLabel.setForeground(this.statusLabel.getDisplay().getSystemColor(3));
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.statusLabel);
        this.findButton = this.createButton(panel, 1024, Messages.getString("Search.findButtonLabel"), false);
        GridDataFactory.swtDefaults().align(131072, 1024).grab(false, false).hint(52, -1).applyTo((Control)this.findButton);
        this.findButton.setEnabled(false);
        this.getShell().setDefaultButton(this.findButton);
        this.findButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SearchDialog.this.doFind();
            }
        });
        Button closeButton = this.createButton(panel, 1, IDialogConstants.CANCEL_LABEL, false);
        GridDataFactory.swtDefaults().align(131072, 1024).grab(false, false).hint(52, -1).applyTo((Control)closeButton);
        return panel;
    }

    private Composite createInputPanel(Composite composite) {
        Composite row = new Composite(composite, 0);
        row.setLayout((Layout)new GridLayout(2, false));
        Label findLabel = new Label(row, 0);
        findLabel.setText(String.valueOf(Messages.getString("Search.findLabel")) + ":");
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)findLabel);
        this.findText = new Text(row, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.findText);
        this.findText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SearchDialog.this.findButton.setEnabled(SearchDialog.this.findText.getText().length() > 0);
            }
        });
        this.findText.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                if (SearchDialog.this.findButton.isEnabled()) {
                    SearchDialog.this.doFind();
                }
            }
        });
        return row;
    }

    private Composite createOptionsPanel(Composite composite) {
        Composite row = new Composite(composite, 0);
        row.setLayout((Layout)new GridLayout(2, true));
        Group directionGroup = new Group(row, 16);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)directionGroup);
        directionGroup.setText(Messages.getString("Search.direction"));
        RowLayout rowLayout = new RowLayout(512);
        rowLayout.marginWidth = 3;
        rowLayout.marginHeight = 3;
        directionGroup.setLayout((Layout)rowLayout);
        this.forwardButton = new Button((Composite)directionGroup, 16);
        this.forwardButton.setText(Messages.getString("Search.forwardButtonLabel"));
        this.forwardButton.setSelection(true);
        Button backwardButton = new Button((Composite)directionGroup, 16);
        backwardButton.setText(Messages.getString("Search.backwardButtonLabel"));
        Group optionsGroup = new Group(row, 16);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)optionsGroup);
        optionsGroup.setText(Messages.getString("Search.options"));
        optionsGroup.setLayout((Layout)rowLayout);
        this.caseSensitiveButton = new Button((Composite)optionsGroup, 32);
        this.caseSensitiveButton.setText(Messages.getString("Search.caseSensitiveButtonLabel"));
        this.wrapSearchButton = new Button((Composite)optionsGroup, 32);
        this.wrapSearchButton.setText(Messages.getString("Search.wrapSearchButtonLabel"));
        this.wrapSearchButton.setSelection(true);
        return row;
    }

    private void doFind() {
        BusyIndicator.showWhile((Display)super.getShell().getDisplay(), (Runnable)new Runnable(){
            private PositionCoordinate searchResultCoordinate;

            @Override
            public void run() {
                this.searchResultCoordinate = null;
                SearchDialog.this.statusLabel.setText("");
                String searchDirection = SearchDialog.this.forwardButton.getSelection() ? "forward" : "backwards";
                SearchCommand command = new SearchCommand(SearchDialog.this.findText.getText(), SearchDialog.this.layer, SearchDialog.this.searchStrategy, searchDirection, SearchDialog.this.wrapSearchButton.getSelection(), SearchDialog.this.caseSensitiveButton.getSelection(), SearchDialog.this.comparator);
                ILayerListener searchEventListener = this.initSearchEventListener();
                command.setSearchEventListener(searchEventListener);
                try {
                    SearchDialog.this.layer.doCommand(command);
                    if (this.searchResultCoordinate == null || this.searchResultCoordinate.columnPosition < 0 && this.searchResultCoordinate.rowPosition < 0) {
                        SearchDialog.this.statusLabel.setText(Messages.getString("Search.textNotFound"));
                    }
                }
                finally {
                    command.getContext().removeLayerListener(searchEventListener);
                }
            }

            private ILayerListener initSearchEventListener() {
                ILayerListener searchEventListener = new ILayerListener(){

                    @Override
                    public void handleLayerEvent(ILayerEvent event) {
                        if (event instanceof SearchEvent) {
                            SearchEvent searchEvent = (SearchEvent)event;
                            searchResultCoordinate = searchEvent.getCellCoordinate();
                        }
                    }
                };
                return searchEventListener;
            }
        });
    }
}

