/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.search.command;

import org.eclipse.nebula.widgets.nattable.command.ILayerCommandHandler;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.search.command.SearchCommand;
import org.eclipse.nebula.widgets.nattable.search.event.SearchEvent;
import org.eclipse.nebula.widgets.nattable.search.strategy.AbstractSearchStrategy;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.selection.command.SelectCellCommand;

public class SearchGridCellsCommandHandler
implements ILayerCommandHandler<SearchCommand> {
    private final SelectionLayer selectionLayer;
    private PositionCoordinate searchResultCellCoordinate;

    public SearchGridCellsCommandHandler(SelectionLayer selectionLayer) {
        this.selectionLayer = selectionLayer;
    }

    @Override
    public Class<SearchCommand> getCommandClass() {
        return SearchCommand.class;
    }

    @Override
    public boolean doCommand(ILayer targetLayer, SearchCommand searchCommand) {
        searchCommand.convertToTargetLayer(targetLayer);
        AbstractSearchStrategy searchStrategy = (AbstractSearchStrategy)searchCommand.getSearchStrategy();
        if (searchCommand.getSearchEventListener() != null) {
            this.selectionLayer.addLayerListener(searchCommand.getSearchEventListener());
        }
        PositionCoordinate anchor = this.selectionLayer.getSelectionAnchor();
        if (anchor.columnPosition < 0 || anchor.rowPosition < 0) {
            anchor = new PositionCoordinate(this.selectionLayer, 0, 0);
        }
        searchStrategy.setContextLayer(targetLayer);
        Object dataValueToFind = null;
        dataValueToFind = searchCommand.getSearchText();
        if (dataValueToFind == null) {
            dataValueToFind = this.selectionLayer.getDataValueByPosition(anchor.columnPosition, anchor.rowPosition);
        }
        searchStrategy.setCaseSensitive(searchCommand.isCaseSensitive());
        searchStrategy.setWrapSearch(searchCommand.isWrapSearch());
        searchStrategy.setSearchDirection(searchCommand.getSearchDirection());
        searchStrategy.setComparator(searchCommand.getComparator());
        this.searchResultCellCoordinate = searchStrategy.executeSearch(dataValueToFind);
        this.selectionLayer.fireLayerEvent(new SearchEvent(this.searchResultCellCoordinate));
        if (this.searchResultCellCoordinate != null) {
            SelectCellCommand command = new SelectCellCommand(this.selectionLayer, this.searchResultCellCoordinate.columnPosition, this.searchResultCellCoordinate.rowPosition, false, false);
            command.setForcingEntireCellIntoViewport(true);
            this.selectionLayer.doCommand(command);
        }
        return true;
    }

    public PositionCoordinate getSearchResultCellCoordinate() {
        return this.searchResultCellCoordinate;
    }
}

