/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.resize.mode;

import java.util.HashSet;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.painter.IOverlayPainter;
import org.eclipse.nebula.widgets.nattable.resize.command.ColumnResizeCommand;
import org.eclipse.nebula.widgets.nattable.ui.action.IDragMode;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeDetectUtil;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class ColumnResizeDragMode
implements IDragMode {
    private static final int DEFAULT_COLUMN_WIDTH_MINIMUM = 25;
    private int columnPositionToResize;
    private int originalColumnWidth;
    private int startX;
    private int currentX;
    private int lastX = -1;
    private int gridColumnStartX;
    private final IOverlayPainter overlayPainter = new ColumnResizeOverlayPainter();

    @Override
    public void mouseDown(NatTable natTable, MouseEvent event) {
        natTable.forceFocus();
        this.columnPositionToResize = CellEdgeDetectUtil.getColumnPositionToResize(natTable, new Point(event.x, event.y));
        if (this.columnPositionToResize >= 0) {
            this.gridColumnStartX = natTable.getStartXOfColumnPosition(this.columnPositionToResize);
            this.originalColumnWidth = natTable.getColumnWidthByPosition(this.columnPositionToResize);
            this.startX = event.x;
            natTable.addOverlayPainter(this.overlayPainter);
        }
    }

    @Override
    public void mouseMove(NatTable natTable, MouseEvent event) {
        if (event.x > natTable.getWidth()) {
            return;
        }
        this.currentX = event.x;
        if (this.currentX < this.gridColumnStartX + this.getColumnWidthMinimum()) {
            this.currentX = this.gridColumnStartX + this.getColumnWidthMinimum();
        } else {
            int overlayExtent = 1;
            HashSet<Integer> columnsToRepaint = new HashSet<Integer>();
            columnsToRepaint.add(natTable.getColumnPositionByX(this.currentX - overlayExtent));
            columnsToRepaint.add(natTable.getColumnPositionByX(this.currentX + overlayExtent));
            if (this.lastX >= 0) {
                columnsToRepaint.add(natTable.getColumnPositionByX(this.lastX - overlayExtent));
                columnsToRepaint.add(natTable.getColumnPositionByX(this.lastX + overlayExtent));
            }
            for (Integer columnToRepaint : columnsToRepaint) {
                natTable.repaintColumn(columnToRepaint);
            }
            this.lastX = this.currentX;
        }
    }

    @Override
    public void mouseUp(NatTable natTable, MouseEvent event) {
        natTable.removeOverlayPainter(this.overlayPainter);
        this.updateColumnWidth(natTable, event);
    }

    private void updateColumnWidth(ILayer natLayer, MouseEvent e) {
        int dragWidth = e.x - this.startX;
        int newColumnWidth = this.originalColumnWidth + dragWidth;
        if (newColumnWidth < this.getColumnWidthMinimum()) {
            newColumnWidth = this.getColumnWidthMinimum();
        }
        natLayer.doCommand(new ColumnResizeCommand(natLayer, this.columnPositionToResize, newColumnWidth));
    }

    private int getColumnWidthMinimum() {
        return 25;
    }

    private class ColumnResizeOverlayPainter
    implements IOverlayPainter {
        static final int COLUMN_RESIZE_OVERLAY_WIDTH = 2;

        private ColumnResizeOverlayPainter() {
        }

        @Override
        public void paintOverlay(GC gc, ILayer layer) {
            Color originalBackgroundColor = gc.getBackground();
            gc.setBackground(GUIHelper.COLOR_DARK_GRAY);
            gc.fillRectangle(ColumnResizeDragMode.this.currentX - 1, 0, 2, layer.getHeight());
            gc.setBackground(originalBackgroundColor);
        }
    }
}

