/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.reorder.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.RowStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

public class RowReorderEvent
extends RowStructuralChangeEvent {
    private Collection<Range> beforeFromRowPositionRanges;
    private int beforeToRowPosition;
    private boolean reorderToTopEdge;

    public RowReorderEvent(ILayer layer, int beforeFromRowPosition, int beforeToRowPosition, boolean reorderToTopEdge) {
        this(layer, Arrays.asList(beforeFromRowPosition), beforeToRowPosition, reorderToTopEdge);
    }

    public RowReorderEvent(ILayer layer, List<Integer> beforeFromRowPositions, int beforeToRowPosition, boolean reorderToTopEdge) {
        super(layer, new Range[0]);
        this.beforeFromRowPositionRanges = PositionUtil.getRanges(beforeFromRowPositions);
        this.reorderToTopEdge = reorderToTopEdge;
        this.beforeToRowPosition = beforeToRowPosition;
        ArrayList<Integer> allRowPositions = new ArrayList<Integer>(beforeFromRowPositions);
        allRowPositions.add(beforeToRowPosition);
        this.setRowPositionRanges(PositionUtil.getRanges(allRowPositions));
    }

    public RowReorderEvent(RowReorderEvent event) {
        super(event);
        this.beforeFromRowPositionRanges = event.beforeFromRowPositionRanges;
        this.beforeToRowPosition = event.beforeToRowPosition;
        this.reorderToTopEdge = event.reorderToTopEdge;
    }

    public Collection<Range> getBeforeFromRowPositionRanges() {
        return this.beforeFromRowPositionRanges;
    }

    public int getBeforeToRowPosition() {
        return this.beforeToRowPosition;
    }

    public boolean isReorderToTopEdge() {
        return this.reorderToTopEdge;
    }

    @Override
    public Collection<StructuralDiff> getRowDiffs() {
        ArrayList<StructuralDiff> rowDiffs = new ArrayList<StructuralDiff>();
        Collection<Range> beforeFromRowPositionRanges = this.getBeforeFromRowPositionRanges();
        int afterAddRowPosition = this.beforeToRowPosition;
        for (Range beforeFromRowPositionRange : beforeFromRowPositionRanges) {
            if (beforeFromRowPositionRange.start >= this.beforeToRowPosition) break;
            afterAddRowPosition -= Math.min(beforeFromRowPositionRange.end, this.beforeToRowPosition) - beforeFromRowPositionRange.start;
        }
        int cumulativeAddSize = 0;
        for (Range beforeFromRowPositionRange : beforeFromRowPositionRanges) {
            cumulativeAddSize += beforeFromRowPositionRange.size();
        }
        int offset = 0;
        for (Range beforeFromRowPositionRange : beforeFromRowPositionRanges) {
            int afterDeleteRowPosition = beforeFromRowPositionRange.start - offset;
            if (afterAddRowPosition < afterDeleteRowPosition) {
                afterDeleteRowPosition += cumulativeAddSize;
            }
            rowDiffs.add(new StructuralDiff(StructuralDiff.DiffTypeEnum.DELETE, beforeFromRowPositionRange, new Range(afterDeleteRowPosition, afterDeleteRowPosition)));
            offset += beforeFromRowPositionRange.size();
        }
        Range beforeAddRange = new Range(this.beforeToRowPosition, this.beforeToRowPosition);
        offset = 0;
        for (Range beforeFromRowPositionRange : beforeFromRowPositionRanges) {
            int size = beforeFromRowPositionRange.size();
            rowDiffs.add(new StructuralDiff(StructuralDiff.DiffTypeEnum.ADD, beforeAddRange, new Range(afterAddRowPosition + offset, afterAddRowPosition + offset + size)));
            offset += size;
        }
        return rowDiffs;
    }

    @Override
    public boolean convertToLocal(ILayer targetLayer) {
        this.beforeFromRowPositionRanges = targetLayer.underlyingToLocalRowPositions(this.getLayer(), this.beforeFromRowPositionRanges);
        this.beforeToRowPosition = targetLayer.underlyingToLocalRowPosition(this.getLayer(), this.beforeToRowPosition);
        if (this.beforeToRowPosition >= 0) {
            return super.convertToLocal(targetLayer);
        }
        return false;
    }

    @Override
    public RowReorderEvent cloneEvent() {
        return new RowReorderEvent(this);
    }
}

