/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.reorder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionUtil;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.AbstractLayerTransform;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.LayerUtil;
import org.eclipse.nebula.widgets.nattable.layer.event.ColumnStructuralRefreshEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.ILayerEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.IStructuralChangeEvent;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderEndCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.command.ColumnReorderStartCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.command.MultiColumnReorderCommandHandler;
import org.eclipse.nebula.widgets.nattable.reorder.config.DefaultColumnReorderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.reorder.event.ColumnReorderEvent;

public class ColumnReorderLayer
extends AbstractLayerTransform
implements IUniqueIndexLayer {
    public static final String PERSISTENCE_KEY_COLUMN_INDEX_ORDER = ".columnIndexOrder";
    private final IUniqueIndexLayer underlyingLayer;
    private final List<Integer> columnIndexOrder = new ArrayList<Integer>();
    private final Map<Integer, Integer> startXCache = new HashMap<Integer, Integer>();
    private int reorderFromColumnPosition;

    public ColumnReorderLayer(IUniqueIndexLayer underlyingLayer) {
        this(underlyingLayer, true);
    }

    public ColumnReorderLayer(IUniqueIndexLayer underlyingLayer, boolean useDefaultConfiguration) {
        super(underlyingLayer);
        this.underlyingLayer = underlyingLayer;
        this.populateIndexOrder();
        this.registerCommandHandlers();
        if (useDefaultConfiguration) {
            this.addConfiguration(new DefaultColumnReorderLayerConfiguration());
        }
    }

    @Override
    public void handleLayerEvent(ILayerEvent event) {
        IStructuralChangeEvent structuralChangeEvent;
        if (event instanceof IStructuralChangeEvent && (structuralChangeEvent = (IStructuralChangeEvent)event).isHorizontalStructureChanged()) {
            Collection<StructuralDiff> structuralDiffs = structuralChangeEvent.getColumnDiffs();
            if (structuralDiffs == null) {
                this.columnIndexOrder.clear();
                this.populateIndexOrder();
            } else {
                for (StructuralDiff structuralDiff : structuralDiffs) {
                    switch (structuralDiff.getDiffType()) {
                        case ADD: {
                            this.columnIndexOrder.clear();
                            this.populateIndexOrder();
                            break;
                        }
                        case DELETE: {
                            this.columnIndexOrder.clear();
                            this.populateIndexOrder();
                        }
                    }
                }
            }
            this.invalidateCache();
        }
        super.handleLayerEvent(event);
    }

    @Override
    protected void registerCommandHandlers() {
        this.registerCommandHandler(new ColumnReorderCommandHandler(this));
        this.registerCommandHandler(new ColumnReorderStartCommandHandler(this));
        this.registerCommandHandler(new ColumnReorderEndCommandHandler(this));
        this.registerCommandHandler(new MultiColumnReorderCommandHandler(this));
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        super.saveState(prefix, properties);
        if (this.columnIndexOrder.size() > 0) {
            StringBuilder strBuilder = new StringBuilder();
            for (Integer index : this.columnIndexOrder) {
                strBuilder.append(index);
                strBuilder.append(',');
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_COLUMN_INDEX_ORDER, strBuilder.toString());
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        super.loadState(prefix, properties);
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_COLUMN_INDEX_ORDER);
        if (property != null) {
            ArrayList<Integer> newColumnIndexOrder = new ArrayList<Integer>();
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String index = tok.nextToken();
                newColumnIndexOrder.add(Integer.valueOf(index));
            }
            if (this.isRestoredStateValid(newColumnIndexOrder)) {
                this.columnIndexOrder.clear();
                this.columnIndexOrder.addAll(newColumnIndexOrder);
            }
        }
        this.fireLayerEvent(new ColumnStructuralRefreshEvent(this));
    }

    protected boolean isRestoredStateValid(List<Integer> newColumnIndexOrder) {
        if (newColumnIndexOrder.size() != this.getColumnCount()) {
            System.err.println("Number of persisted columns (" + newColumnIndexOrder.size() + ") " + "is not the same as the number of columns in the data source (" + this.getColumnCount() + ").\n" + "Skipping restore of column ordering");
            return false;
        }
        for (Integer index : newColumnIndexOrder) {
            if (this.columnIndexOrder.contains(index)) continue;
            System.err.println("Column index: " + index + " being restored, is not a available in the data soure.\n" + "Skipping restore of column ordering");
            return false;
        }
        return true;
    }

    public List<Integer> getColumnIndexOrder() {
        return this.columnIndexOrder;
    }

    @Override
    public int getColumnIndexByPosition(int columnPosition) {
        if (columnPosition >= 0 && columnPosition < this.columnIndexOrder.size()) {
            return this.columnIndexOrder.get(columnPosition);
        }
        return -1;
    }

    @Override
    public int getColumnPositionByIndex(int columnIndex) {
        return this.columnIndexOrder.indexOf(columnIndex);
    }

    @Override
    public int localToUnderlyingColumnPosition(int localColumnPosition) {
        int columnIndex = this.getColumnIndexByPosition(localColumnPosition);
        return this.underlyingLayer.getColumnPositionByIndex(columnIndex);
    }

    @Override
    public int underlyingToLocalColumnPosition(ILayer sourceUnderlyingLayer, int underlyingColumnPosition) {
        int columnIndex = this.underlyingLayer.getColumnIndexByPosition(underlyingColumnPosition);
        return this.getColumnPositionByIndex(columnIndex);
    }

    @Override
    public Collection<Range> underlyingToLocalColumnPositions(ILayer sourceUnderlyingLayer, Collection<Range> underlyingColumnPositionRanges) {
        ArrayList<Integer> reorderedColumnPositions = new ArrayList<Integer>();
        for (Range underlyingColumnPositionRange : underlyingColumnPositionRanges) {
            int underlyingColumnPosition = underlyingColumnPositionRange.start;
            while (underlyingColumnPosition < underlyingColumnPositionRange.end) {
                int localColumnPosition = this.underlyingToLocalColumnPosition(sourceUnderlyingLayer, underlyingColumnPositionRange.start);
                reorderedColumnPositions.add(localColumnPosition);
                ++underlyingColumnPosition;
            }
        }
        Collections.sort(reorderedColumnPositions);
        return PositionUtil.getRanges(reorderedColumnPositions);
    }

    @Override
    public int getColumnPositionByX(int x) {
        return LayerUtil.getColumnPositionByX(this, x);
    }

    @Override
    public int getStartXOfColumnPosition(int targetColumnPosition) {
        Integer cachedStartX = this.startXCache.get(targetColumnPosition);
        if (cachedStartX != null) {
            return cachedStartX;
        }
        int aggregateWidth = 0;
        int columnPosition = 0;
        while (columnPosition < targetColumnPosition) {
            aggregateWidth += this.underlyingLayer.getColumnWidthByPosition(this.localToUnderlyingColumnPosition(columnPosition));
            ++columnPosition;
        }
        this.startXCache.put(targetColumnPosition, aggregateWidth);
        return aggregateWidth;
    }

    private void populateIndexOrder() {
        ILayer underlyingLayer = this.getUnderlyingLayer();
        int columnPosition = 0;
        while (columnPosition < underlyingLayer.getColumnCount()) {
            this.columnIndexOrder.add(underlyingLayer.getColumnIndexByPosition(columnPosition));
            ++columnPosition;
        }
    }

    @Override
    public int getRowPositionByIndex(int rowIndex) {
        return this.underlyingLayer.getRowPositionByIndex(rowIndex);
    }

    private void moveColumn(int fromColumnPosition, int toColumnPosition, boolean reorderToLeftEdge) {
        if (!reorderToLeftEdge) {
            ++toColumnPosition;
        }
        Integer fromColumnIndex = this.columnIndexOrder.get(fromColumnPosition);
        this.columnIndexOrder.add(toColumnPosition, fromColumnIndex);
        this.columnIndexOrder.remove(fromColumnPosition + (fromColumnPosition > toColumnPosition ? 1 : 0));
        this.invalidateCache();
    }

    public void reorderColumnPosition(int fromColumnPosition, int toColumnPosition) {
        boolean reorderToLeftEdge;
        if (toColumnPosition < this.getColumnCount()) {
            reorderToLeftEdge = true;
        } else {
            reorderToLeftEdge = false;
            --toColumnPosition;
        }
        this.reorderColumnPosition(fromColumnPosition, toColumnPosition, reorderToLeftEdge);
    }

    public void reorderColumnPosition(int fromColumnPosition, int toColumnPosition, boolean reorderToLeftEdge) {
        this.moveColumn(fromColumnPosition, toColumnPosition, reorderToLeftEdge);
        this.fireLayerEvent(new ColumnReorderEvent((ILayer)this, fromColumnPosition, toColumnPosition, reorderToLeftEdge));
    }

    public void reorderMultipleColumnPositions(List<Integer> fromColumnPositions, int toColumnPosition) {
        boolean reorderToLeftEdge;
        if (toColumnPosition < this.getColumnCount()) {
            reorderToLeftEdge = true;
        } else {
            reorderToLeftEdge = false;
            --toColumnPosition;
        }
        this.reorderMultipleColumnPositions(fromColumnPositions, toColumnPosition, reorderToLeftEdge);
    }

    public void reorderMultipleColumnPositions(List<Integer> fromColumnPositions, int toColumnPosition, boolean reorderToLeftEdge) {
        int fromColumnPositionsCount = fromColumnPositions.size();
        if (toColumnPosition > fromColumnPositions.get(fromColumnPositionsCount - 1)) {
            int firstColumnPosition = fromColumnPositions.get(0);
            int columnCount = 0;
            while (columnCount < fromColumnPositionsCount) {
                int fromColumnPosition = fromColumnPositions.get(0);
                this.moveColumn(fromColumnPosition, toColumnPosition, reorderToLeftEdge);
                if (fromColumnPosition < firstColumnPosition) {
                    firstColumnPosition = fromColumnPosition;
                }
                ++columnCount;
            }
        } else if (toColumnPosition < fromColumnPositions.get(fromColumnPositionsCount - 1)) {
            int targetColumnPosition = toColumnPosition;
            for (Integer fromColumnPosition : fromColumnPositions) {
                int fromColumnPositionInt = fromColumnPosition;
                this.moveColumn(fromColumnPositionInt, targetColumnPosition++, reorderToLeftEdge);
            }
        }
        this.fireLayerEvent(new ColumnReorderEvent((ILayer)this, fromColumnPositions, toColumnPosition, reorderToLeftEdge));
    }

    private void invalidateCache() {
        this.startXCache.clear();
    }

    public int getReorderFromColumnPosition() {
        return this.reorderFromColumnPosition;
    }

    public void setReorderFromColumnPosition(int fromColumnPosition) {
        this.reorderFromColumnPosition = fromColumnPosition;
    }
}

