/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.layer;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.painter.layer.CellLayerPainter;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class GridLineCellLayerPainter
extends CellLayerPainter {
    private final Color gridColor;

    public GridLineCellLayerPainter(Color gridColor) {
        this.gridColor = gridColor;
    }

    public GridLineCellLayerPainter() {
        this.gridColor = GUIHelper.COLOR_GRAY;
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle rectangle, IConfigRegistry configRegistry) {
        this.drawGridLines(natLayer, gc, rectangle);
        super.paintLayer(natLayer, gc, xOffset, yOffset, rectangle, configRegistry);
    }

    @Override
    public Rectangle adjustCellBounds(int columnPosition, int rowPosition, Rectangle bounds) {
        return new Rectangle(bounds.x, bounds.y, Math.max(bounds.width - 1, 0), Math.max(bounds.height - 1, 0));
    }

    protected void drawGridLines(ILayer natLayer, GC gc, Rectangle rectangle) {
        gc.setForeground(this.gridColor);
        this.drawHorizontalLines(natLayer, gc, rectangle);
        this.drawVerticalLines(natLayer, gc, rectangle);
    }

    private void drawHorizontalLines(ILayer natLayer, GC gc, Rectangle rectangle) {
        int endX = rectangle.x + Math.min(natLayer.getWidth() - 1, rectangle.width);
        int rowPositionByY = natLayer.getRowPositionByY(rectangle.y + rectangle.height);
        int maxRowPosition = rowPositionByY > 0 ? Math.min(natLayer.getRowCount(), rowPositionByY) : natLayer.getRowCount();
        int rowPosition = natLayer.getRowPositionByY(rectangle.y);
        while (rowPosition < maxRowPosition) {
            int size = natLayer.getRowHeightByPosition(rowPosition);
            if (size > 0) {
                int y = natLayer.getStartYOfRowPosition(rowPosition) + size - 1;
                gc.drawLine(rectangle.x, y, endX, y);
            }
            ++rowPosition;
        }
    }

    private void drawVerticalLines(ILayer natLayer, GC gc, Rectangle rectangle) {
        int endY = rectangle.y + Math.min(natLayer.getHeight() - 1, rectangle.height);
        int columnPositionByX = natLayer.getColumnPositionByX(rectangle.x + rectangle.width);
        int maxColumnPosition = columnPositionByX > 0 ? Math.min(natLayer.getColumnCount(), columnPositionByX) : natLayer.getColumnCount();
        int columnPosition = natLayer.getColumnPositionByX(rectangle.x);
        while (columnPosition < maxColumnPosition) {
            int size = natLayer.getColumnWidthByPosition(columnPosition);
            if (size > 0) {
                int x = natLayer.getStartXOfColumnPosition(columnPosition) + size - 1;
                gc.drawLine(x, rectangle.y, x, endY);
            }
            ++columnPosition;
        }
    }
}

