/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.layer;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.layer.ILayerPainter;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class CellLayerPainter
implements ILayerPainter {
    private ILayer natLayer;
    private Map<Integer, Integer> horizontalPositionToPixelMap;
    private Map<Integer, Integer> verticalPositionToPixelMap;

    @Override
    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configRegistry) {
        if (pixelRectangle.width <= 0 || pixelRectangle.height <= 0) {
            return;
        }
        this.calculateDimensionInfo(natLayer);
        HashSet<ILayerCell> spannedCells = new HashSet<ILayerCell>();
        Rectangle positionRectangle = this.getPositionRectangleFromPixelRectangle(natLayer, pixelRectangle);
        int columnPosition = positionRectangle.x;
        while (columnPosition < positionRectangle.x + positionRectangle.width) {
            int rowPosition = positionRectangle.y;
            while (rowPosition < positionRectangle.y + positionRectangle.height) {
                ILayerCell cell = natLayer.getCellByPosition(columnPosition, rowPosition);
                if (cell != null) {
                    if (cell.isSpannedCell()) {
                        spannedCells.add(cell);
                    } else {
                        this.paintCell(cell, gc, configRegistry);
                    }
                }
                ++rowPosition;
            }
            ++columnPosition;
        }
        for (ILayerCell cell : spannedCells) {
            this.paintCell(cell, gc, configRegistry);
        }
    }

    private void calculateDimensionInfo(ILayer natLayer) {
        this.natLayer = natLayer;
        this.horizontalPositionToPixelMap = new HashMap<Integer, Integer>();
        this.verticalPositionToPixelMap = new HashMap<Integer, Integer>();
        int columnPosition = 0;
        while (columnPosition < natLayer.getColumnCount()) {
            int rowPosition = 0;
            while (rowPosition < natLayer.getRowCount()) {
                int x = natLayer.getStartXOfColumnPosition(columnPosition);
                Integer extantX = this.horizontalPositionToPixelMap.get(columnPosition);
                int width = natLayer.getColumnWidthByPosition(columnPosition);
                this.horizontalPositionToPixelMap.put(columnPosition, extantX != null ? Math.max(x, extantX) : x);
                this.horizontalPositionToPixelMap.put(columnPosition + 1, x + width);
                int y = natLayer.getStartYOfRowPosition(rowPosition);
                Integer extantY = this.verticalPositionToPixelMap.get(rowPosition);
                int height = natLayer.getRowHeightByPosition(rowPosition);
                this.verticalPositionToPixelMap.put(rowPosition, extantY != null ? Math.max(y, extantY) : y);
                this.verticalPositionToPixelMap.put(rowPosition + 1, y + height);
                ++rowPosition;
            }
            ++columnPosition;
        }
    }

    @Override
    public Rectangle adjustCellBounds(int columnPosition, int rowPosition, Rectangle cellBounds) {
        return cellBounds;
    }

    protected Rectangle getPositionRectangleFromPixelRectangle(ILayer natLayer, Rectangle pixelRectangle) {
        int columnPositionOffset = natLayer.getColumnPositionByX(pixelRectangle.x);
        int rowPositionOffset = natLayer.getRowPositionByY(pixelRectangle.y);
        int numColumns = natLayer.getColumnPositionByX(Math.min(natLayer.getWidth(), pixelRectangle.x + pixelRectangle.width) - 1) - columnPositionOffset + 1;
        int numRows = natLayer.getRowPositionByY(Math.min(natLayer.getHeight(), pixelRectangle.y + pixelRectangle.height) - 1) - rowPositionOffset + 1;
        return new Rectangle(columnPositionOffset, rowPositionOffset, numColumns, numRows);
    }

    protected void paintCell(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        ILayer layer = cell.getLayer();
        int columnPosition = cell.getColumnPosition();
        int rowPosition = cell.getRowPosition();
        ICellPainter cellPainter = layer.getCellPainter(columnPosition, rowPosition, cell, configRegistry);
        Rectangle adjustedCellBounds = layer.getLayerPainter().adjustCellBounds(columnPosition, rowPosition, cell.getBounds());
        if (cellPainter != null) {
            Rectangle originalClipping = gc.getClipping();
            int startX = this.getStartXOfColumnPosition(columnPosition);
            int startY = this.getStartYOfRowPosition(rowPosition);
            int endX = this.getStartXOfColumnPosition(cell.getOriginColumnPosition() + cell.getColumnSpan());
            int endY = this.getStartYOfRowPosition(cell.getOriginRowPosition() + cell.getRowSpan());
            Rectangle clipBounds = new Rectangle(startX, startY, endX - startX, endY - startY);
            Rectangle adjustedClipBounds = layer.getLayerPainter().adjustCellBounds(columnPosition, rowPosition, clipBounds);
            gc.setClipping(adjustedClipBounds);
            cellPainter.paintCell(cell, gc, adjustedCellBounds, configRegistry);
            gc.setClipping(originalClipping);
        }
    }

    int getStartXOfColumnPosition(int columnPosition) {
        if (columnPosition < this.natLayer.getColumnCount()) {
            return this.horizontalPositionToPixelMap.get(columnPosition);
        }
        return this.natLayer.getWidth();
    }

    int getStartYOfRowPosition(int rowPosition) {
        if (rowPosition < this.natLayer.getRowCount()) {
            return this.verticalPositionToPixelMap.get(rowPosition);
        }
        return this.natLayer.getHeight();
    }
}

