/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.painter.cell.decorator;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.style.CellStyleAttributes;
import org.eclipse.nebula.widgets.nattable.style.CellStyleUtil;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class CellPainterDecorator
implements ICellPainter {
    private final ICellPainter baseCellPainter;
    private final CellEdgeEnum cellEdge;
    private final ICellPainter decoratorCellPainter;
    private final int spacing;
    private boolean paintDecorationDependent;

    public CellPainterDecorator(ICellPainter baseCellPainter, CellEdgeEnum cellEdge, ICellPainter decoratorCellPainter) {
        this(baseCellPainter, cellEdge, 2, decoratorCellPainter);
    }

    public CellPainterDecorator(ICellPainter baseCellPainter, CellEdgeEnum cellEdge, ICellPainter decoratorCellPainter, boolean paintDecorationDependent) {
        this(baseCellPainter, cellEdge, 2, decoratorCellPainter, paintDecorationDependent);
    }

    public CellPainterDecorator(ICellPainter baseCellPainter, CellEdgeEnum cellEdge, int spacing, ICellPainter decoratorCellPainter) {
        this(baseCellPainter, cellEdge, spacing, decoratorCellPainter, true);
    }

    public CellPainterDecorator(ICellPainter baseCellPainter, CellEdgeEnum cellEdge, int spacing, ICellPainter decoratorCellPainter, boolean paintDecorationDependent) {
        this.baseCellPainter = baseCellPainter;
        this.cellEdge = cellEdge;
        this.spacing = spacing;
        this.decoratorCellPainter = decoratorCellPainter;
        this.paintDecorationDependent = paintDecorationDependent;
    }

    public void setPaintDecorationDependent(boolean paintDecorationDependent) {
        this.paintDecorationDependent = paintDecorationDependent;
    }

    public void setBaseCellPainterSpansWholeCell(boolean interiorPainterToSpanFullWidth) {
        this.paintDecorationDependent = !interiorPainterToSpanFullWidth;
    }

    @Override
    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        switch (this.cellEdge) {
            case TOP: 
            case BOTTOM: 
            case TOP_LEFT: 
            case TOP_RIGHT: 
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: {
                return this.spacing + Math.max(this.baseCellPainter.getPreferredWidth(cell, gc, configRegistry), this.decoratorCellPainter.getPreferredWidth(cell, gc, configRegistry));
            }
        }
        return this.baseCellPainter.getPreferredWidth(cell, gc, configRegistry) + this.spacing + this.decoratorCellPainter.getPreferredWidth(cell, gc, configRegistry);
    }

    @Override
    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        switch (this.cellEdge) {
            case LEFT: 
            case RIGHT: 
            case TOP_LEFT: 
            case TOP_RIGHT: 
            case BOTTOM_LEFT: 
            case BOTTOM_RIGHT: {
                return this.spacing + Math.max(this.baseCellPainter.getPreferredHeight(cell, gc, configRegistry), this.decoratorCellPainter.getPreferredHeight(cell, gc, configRegistry));
            }
        }
        return this.baseCellPainter.getPreferredHeight(cell, gc, configRegistry) + this.spacing + this.decoratorCellPainter.getPreferredHeight(cell, gc, configRegistry);
    }

    @Override
    public void paintCell(ILayerCell cell, GC gc, Rectangle adjustedCellBounds, IConfigRegistry configRegistry) {
        Rectangle baseCellPainterBounds = this.paintDecorationDependent ? this.getBaseCellPainterBounds(cell, gc, adjustedCellBounds, configRegistry) : adjustedCellBounds;
        Rectangle decoratorCellPainterBounds = this.getDecoratorCellPainterBounds(cell, gc, adjustedCellBounds, configRegistry);
        Color originalBg = gc.getBackground();
        gc.setBackground(CellStyleUtil.getCellStyle(cell, configRegistry).getAttributeValue(CellStyleAttributes.BACKGROUND_COLOR));
        gc.fillRectangle(adjustedCellBounds);
        gc.setBackground(originalBg);
        this.baseCellPainter.paintCell(cell, gc, baseCellPainterBounds, configRegistry);
        this.decoratorCellPainter.paintCell(cell, gc, decoratorCellPainterBounds, configRegistry);
    }

    public Rectangle getBaseCellPainterBounds(ILayerCell cell, GC gc, Rectangle adjustedCellBounds, IConfigRegistry configRegistry) {
        int preferredDecoratorWidth = this.decoratorCellPainter.getPreferredWidth(cell, gc, configRegistry);
        int preferredDecoratorHeight = this.decoratorCellPainter.getPreferredHeight(cell, gc, configRegistry);
        int grabbedPreferredWidth = adjustedCellBounds.width - preferredDecoratorWidth - this.spacing;
        int grabbedPreferredHeight = adjustedCellBounds.height - preferredDecoratorHeight - this.spacing;
        switch (this.cellEdge) {
            case LEFT: {
                return new Rectangle(adjustedCellBounds.x + preferredDecoratorWidth + this.spacing, adjustedCellBounds.y, grabbedPreferredWidth, adjustedCellBounds.height).intersection(adjustedCellBounds);
            }
            case RIGHT: {
                return new Rectangle(adjustedCellBounds.x, adjustedCellBounds.y, grabbedPreferredWidth, adjustedCellBounds.height).intersection(adjustedCellBounds);
            }
            case TOP: {
                return new Rectangle(adjustedCellBounds.x, adjustedCellBounds.y + preferredDecoratorHeight + this.spacing, adjustedCellBounds.width, grabbedPreferredHeight).intersection(adjustedCellBounds);
            }
            case BOTTOM: {
                return new Rectangle(adjustedCellBounds.x, adjustedCellBounds.y, adjustedCellBounds.width, grabbedPreferredHeight).intersection(adjustedCellBounds);
            }
            case TOP_LEFT: {
                return new Rectangle(adjustedCellBounds.x + preferredDecoratorWidth + this.spacing, adjustedCellBounds.y + preferredDecoratorHeight + this.spacing, grabbedPreferredWidth, grabbedPreferredHeight).intersection(adjustedCellBounds);
            }
            case TOP_RIGHT: {
                return new Rectangle(adjustedCellBounds.x, adjustedCellBounds.y + preferredDecoratorHeight + this.spacing, grabbedPreferredWidth, grabbedPreferredHeight).intersection(adjustedCellBounds);
            }
            case BOTTOM_LEFT: {
                return new Rectangle(adjustedCellBounds.x + preferredDecoratorWidth + this.spacing, adjustedCellBounds.y, grabbedPreferredWidth, grabbedPreferredHeight).intersection(adjustedCellBounds);
            }
            case BOTTOM_RIGHT: {
                return new Rectangle(adjustedCellBounds.x, adjustedCellBounds.y, grabbedPreferredWidth, grabbedPreferredHeight).intersection(adjustedCellBounds);
            }
        }
        return null;
    }

    public Rectangle getDecoratorCellPainterBounds(ILayerCell cell, GC gc, Rectangle adjustedCellBounds, IConfigRegistry configRegistry) {
        int preferredDecoratorWidth = this.decoratorCellPainter.getPreferredWidth(cell, gc, configRegistry);
        int preferredDecoratorHeight = this.decoratorCellPainter.getPreferredHeight(cell, gc, configRegistry);
        switch (this.cellEdge) {
            case LEFT: {
                return new Rectangle(adjustedCellBounds.x, adjustedCellBounds.y + (adjustedCellBounds.height - preferredDecoratorHeight) / 2, preferredDecoratorWidth, preferredDecoratorHeight);
            }
            case RIGHT: {
                return new Rectangle(adjustedCellBounds.x + adjustedCellBounds.width - preferredDecoratorWidth, adjustedCellBounds.y + (adjustedCellBounds.height - preferredDecoratorHeight) / 2, preferredDecoratorWidth, preferredDecoratorHeight);
            }
            case TOP: {
                return new Rectangle(adjustedCellBounds.x + (adjustedCellBounds.width - preferredDecoratorWidth) / 2, adjustedCellBounds.y, preferredDecoratorWidth, preferredDecoratorHeight);
            }
            case BOTTOM: {
                return new Rectangle(adjustedCellBounds.x + (adjustedCellBounds.width - preferredDecoratorWidth) / 2, adjustedCellBounds.y + adjustedCellBounds.height - preferredDecoratorHeight, preferredDecoratorWidth, preferredDecoratorHeight);
            }
            case TOP_LEFT: {
                return new Rectangle(adjustedCellBounds.x, adjustedCellBounds.y, preferredDecoratorWidth, preferredDecoratorHeight);
            }
            case TOP_RIGHT: {
                return new Rectangle(adjustedCellBounds.x + adjustedCellBounds.width - preferredDecoratorWidth, adjustedCellBounds.y, preferredDecoratorWidth, preferredDecoratorHeight);
            }
            case BOTTOM_LEFT: {
                return new Rectangle(adjustedCellBounds.x, adjustedCellBounds.y + adjustedCellBounds.height - preferredDecoratorHeight, preferredDecoratorWidth, preferredDecoratorHeight);
            }
            case BOTTOM_RIGHT: {
                return new Rectangle(adjustedCellBounds.x + adjustedCellBounds.width - preferredDecoratorWidth, adjustedCellBounds.y + adjustedCellBounds.height - preferredDecoratorHeight, preferredDecoratorWidth, preferredDecoratorHeight);
            }
        }
        return null;
    }

    @Override
    public ICellPainter getCellPainterAt(int x, int y, ILayerCell cell, GC gc, Rectangle adjustedCellBounds, IConfigRegistry configRegistry) {
        Rectangle baseCellPainterBounds;
        Rectangle decoratorCellPainterBounds = this.getDecoratorCellPainterBounds(cell, gc, adjustedCellBounds, configRegistry);
        if (decoratorCellPainterBounds.contains(x, y)) {
            return this.decoratorCellPainter.getCellPainterAt(x, y, cell, gc, decoratorCellPainterBounds, configRegistry);
        }
        Rectangle rectangle = baseCellPainterBounds = this.paintDecorationDependent ? this.getBaseCellPainterBounds(cell, gc, adjustedCellBounds, configRegistry) : adjustedCellBounds;
        if (baseCellPainterBounds.contains(x, y)) {
            return this.baseCellPainter.getCellPainterAt(x, y, cell, gc, baseCellPainterBounds, configRegistry);
        }
        return this;
    }
}

