/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.event;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.StructuralDiff;

public class StructuralChangeEventHelper {
    public static void handleRowDelete(Collection<StructuralDiff> rowDiffs, ILayer underlyingLayer, Collection<Integer> cachedRowIndexes, boolean handleNotFound) {
        int numberOfNoIndex = 0;
        ArrayList<Integer> toRemove = new ArrayList<Integer>();
        for (StructuralDiff rowDiff : rowDiffs) {
            if (rowDiff.getDiffType() == null || !rowDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.DELETE)) continue;
            Range beforePositionRange = rowDiff.getBeforePositionRange();
            int i = beforePositionRange.start;
            while (i < beforePositionRange.end) {
                int index = i;
                if (index >= 0) {
                    toRemove.add(index);
                } else {
                    ++numberOfNoIndex;
                }
                ++i;
            }
        }
        cachedRowIndexes.removeAll(toRemove);
        ArrayList<Integer> modifiedRows = new ArrayList<Integer>();
        for (Integer row : cachedRowIndexes) {
            int deletedBefore = handleNotFound ? numberOfNoIndex : 0;
            for (Integer removed : toRemove) {
                if (removed >= row) continue;
                ++deletedBefore;
            }
            int modRow = row - deletedBefore;
            if (modRow < 0) continue;
            modifiedRows.add(modRow);
        }
        cachedRowIndexes.clear();
        cachedRowIndexes.addAll(modifiedRows);
    }

    public static void handleRowInsert(Collection<StructuralDiff> rowDiffs, ILayer underlyingLayer, Collection<Integer> cachedRowIndexes, boolean addToCache) {
        for (StructuralDiff rowDiff : rowDiffs) {
            if (rowDiff.getDiffType() == null || !rowDiff.getDiffType().equals((Object)StructuralDiff.DiffTypeEnum.ADD)) continue;
            Range beforePositionRange = rowDiff.getBeforePositionRange();
            ArrayList<Integer> modifiedRows = new ArrayList<Integer>();
            int beforeIndex = underlyingLayer.getRowIndexByPosition(beforePositionRange.start);
            for (Integer row : cachedRowIndexes) {
                if (row >= beforeIndex) {
                    modifiedRows.add(row + 1);
                    continue;
                }
                modifiedRows.add(row);
            }
            if (addToCache) {
                modifiedRows.add(beforeIndex, beforePositionRange.start);
            }
            cachedRowIndexes.clear();
            cachedRowIndexes.addAll(modifiedRows);
        }
    }
}

