/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.event;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.Range;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.event.IVisualChangeEvent;
import org.eclipse.swt.graphics.Rectangle;

public abstract class RowVisualChangeEvent
implements IVisualChangeEvent {
    private ILayer layer;
    private Collection<Range> rowPositionRanges = new ArrayList<Range>();

    public RowVisualChangeEvent(ILayer layer, Range ... rowPositionRanges) {
        this(layer, Arrays.asList(rowPositionRanges));
    }

    public RowVisualChangeEvent(ILayer layer, Collection<Range> rowPositionRanges) {
        this.layer = layer;
        this.rowPositionRanges = rowPositionRanges;
    }

    protected RowVisualChangeEvent(RowVisualChangeEvent event) {
        this.layer = event.layer;
        this.rowPositionRanges = event.rowPositionRanges;
    }

    @Override
    public ILayer getLayer() {
        return this.layer;
    }

    public Collection<Range> getRowPositionRanges() {
        return this.rowPositionRanges;
    }

    protected void setRowPositionRanges(Collection<Range> rowPositionRanges) {
        this.rowPositionRanges = rowPositionRanges;
    }

    @Override
    public boolean convertToLocal(ILayer localLayer) {
        this.rowPositionRanges = localLayer.underlyingToLocalRowPositions(this.layer, this.rowPositionRanges);
        this.layer = localLayer;
        return this.rowPositionRanges != null && this.rowPositionRanges.size() > 0;
    }

    @Override
    public Collection<Rectangle> getChangedPositionRectangles() {
        ArrayList<Rectangle> changedPositionRectangles = new ArrayList<Rectangle>();
        int columnCount = this.layer.getColumnCount();
        for (Range range : this.rowPositionRanges) {
            changedPositionRectangles.add(new Rectangle(0, range.start, columnCount, range.end - range.start));
        }
        return changedPositionRectangles;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

