/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer;

import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.eclipse.nebula.widgets.nattable.persistence.IPersistable;

public class SizeConfig
implements IPersistable {
    public static final String PERSISTENCE_KEY_DEFAULT_SIZE = ".defaultSize";
    public static final String PERSISTENCE_KEY_DEFAULT_SIZES = ".defaultSizes";
    public static final String PERSISTENCE_KEY_SIZES = ".sizes";
    public static final String PERSISTENCE_KEY_RESIZABLE_BY_DEFAULT = ".resizableByDefault";
    public static final String PERSISTENCE_KEY_RESIZABLE_INDEXES = ".resizableIndexes";
    public static final String PERSISTENCE_KEY_PERCENTAGE_SIZING = ".percentageSizing";
    private int defaultSize;
    private final Map<Integer, Integer> defaultSizeMap = new TreeMap<Integer, Integer>();
    private final Map<Integer, Integer> sizeMap = new TreeMap<Integer, Integer>();
    private final Map<Integer, Boolean> resizablesMap = new TreeMap<Integer, Boolean>();
    private boolean resizableByDefault = true;
    private boolean percentageSizing = false;
    private int availableSpace = -1;
    private final Map<Integer, Integer> realSizeMap = new TreeMap<Integer, Integer>();

    public SizeConfig(int defaultSize) {
        this.defaultSize = defaultSize;
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZE, String.valueOf(this.defaultSize));
        this.saveMap(this.defaultSizeMap, String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZES, properties);
        this.saveMap(this.sizeMap, String.valueOf(prefix) + PERSISTENCE_KEY_SIZES, properties);
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_BY_DEFAULT, String.valueOf(this.resizableByDefault));
        this.saveMap(this.resizablesMap, String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_INDEXES, properties);
        properties.put(String.valueOf(prefix) + PERSISTENCE_KEY_PERCENTAGE_SIZING, String.valueOf(this.percentageSizing));
    }

    private void saveMap(Map<Integer, ?> map, String key, Properties properties) {
        if (map.size() > 0) {
            StringBuilder strBuilder = new StringBuilder();
            for (Integer index : map.keySet()) {
                strBuilder.append(index);
                strBuilder.append(':');
                strBuilder.append(map.get(index));
                strBuilder.append(',');
            }
            properties.setProperty(key, strBuilder.toString());
        }
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        String persistedPercentageSizing;
        String persistedResizableDefault;
        this.defaultSizeMap.clear();
        this.sizeMap.clear();
        this.resizablesMap.clear();
        String persistedDefaultSize = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZE);
        if (!StringUtils.isEmpty((String)persistedDefaultSize)) {
            this.defaultSize = Integer.valueOf(persistedDefaultSize);
        }
        if (!StringUtils.isEmpty((String)(persistedResizableDefault = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_BY_DEFAULT)))) {
            this.resizableByDefault = Boolean.valueOf(persistedResizableDefault);
        }
        if (!StringUtils.isEmpty((String)(persistedPercentageSizing = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_PERCENTAGE_SIZING)))) {
            this.setPercentageSizing(Boolean.valueOf(persistedPercentageSizing));
        }
        this.loadBooleanMap(String.valueOf(prefix) + PERSISTENCE_KEY_RESIZABLE_INDEXES, properties, this.resizablesMap);
        this.loadIntegerMap(String.valueOf(prefix) + PERSISTENCE_KEY_DEFAULT_SIZES, properties, this.defaultSizeMap);
        this.loadIntegerMap(String.valueOf(prefix) + PERSISTENCE_KEY_SIZES, properties, this.sizeMap);
    }

    private void loadIntegerMap(String key, Properties properties, Map<Integer, Integer> map) {
        String property = properties.getProperty(key);
        if (property != null) {
            map.clear();
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int separatorIndex = token.indexOf(58);
                map.put(Integer.valueOf(token.substring(0, separatorIndex)), Integer.valueOf(token.substring(separatorIndex + 1)));
            }
        }
    }

    private void loadBooleanMap(String key, Properties properties, Map<Integer, Boolean> map) {
        String property = properties.getProperty(key);
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int separatorIndex = token.indexOf(58);
                map.put(Integer.valueOf(token.substring(0, separatorIndex)), Boolean.valueOf(token.substring(separatorIndex + 1)));
            }
        }
    }

    public void setDefaultSize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.defaultSize = size;
    }

    public void setDefaultSize(int position, int size) {
        if (this.defaultSize < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.defaultSizeMap.put(position, size);
    }

    private int getDefaultSize(int position) {
        Integer size = this.defaultSizeMap.get(position);
        if (size != null) {
            return size;
        }
        return this.defaultSize;
    }

    public int getAggregateSize(int position) {
        if (position < 0) {
            return -1;
        }
        if (position == 0) {
            return 0;
        }
        if (this.isAllPositionsSameSize() && !this.percentageSizing) {
            return position * this.defaultSize;
        }
        int resizeAggregate = 0;
        int resizedColumns = 0;
        Map<Integer, Integer> mapToUse = this.percentageSizing ? this.realSizeMap : this.sizeMap;
        for (Integer resizedPosition : mapToUse.keySet()) {
            if (resizedPosition >= position) break;
            ++resizedColumns;
            resizeAggregate += mapToUse.get(resizedPosition).intValue();
        }
        return position * this.defaultSize + (resizeAggregate - resizedColumns * this.defaultSize);
    }

    public int getSize(int position) {
        Integer size = this.percentageSizing ? this.realSizeMap.get(position) : this.sizeMap.get(position);
        if (size != null) {
            return size;
        }
        return this.getDefaultSize(position);
    }

    public void setSize(int position, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        if (this.isPositionResizable(position)) {
            if (!this.isPercentageSizing()) {
                this.sizeMap.put(position, size);
            } else if (this.availableSpace > 0) {
                Double percentage = (double)size * 100.0 / (double)this.availableSpace;
                this.sizeMap.put(position, percentage.intValue());
                this.calculatePercentages(this.availableSpace, this.realSizeMap.size());
            }
        }
    }

    public void setPercentage(int position, int percentage) {
        if (percentage < 0) {
            throw new IllegalArgumentException("percentage < 0");
        }
        if (this.isPositionResizable(position) && this.isPercentageSizing()) {
            this.sizeMap.put(position, percentage);
            this.realSizeMap.put(position, this.calculatePercentageValue(percentage, this.availableSpace));
            this.calculatePercentages(this.availableSpace, this.realSizeMap.size());
        }
    }

    public boolean isResizableByDefault() {
        return this.resizableByDefault;
    }

    public boolean isPositionResizable(int position) {
        Boolean resizable = this.resizablesMap.get(position);
        if (resizable != null) {
            return resizable;
        }
        return this.resizableByDefault;
    }

    public void setPositionResizable(int position, boolean resizable) {
        if (this.percentageSizing && resizable) {
            throw new IllegalStateException("Resizable columns are not allowed when using percentaged sizing.");
        }
        this.resizablesMap.put(position, resizable);
    }

    public void setResizableByDefault(boolean resizableByDefault) {
        if (this.percentageSizing && resizableByDefault) {
            throw new IllegalStateException("Resizable columns are not allowed when using percentaged sizing.");
        }
        this.resizablesMap.clear();
        this.resizableByDefault = resizableByDefault;
    }

    public boolean isAllPositionsSameSize() {
        return this.defaultSizeMap.size() == 0 && this.sizeMap.size() == 0;
    }

    public boolean isPercentageSizing() {
        return this.percentageSizing;
    }

    public void setPercentageSizing(boolean percentageSizing) {
        this.percentageSizing = percentageSizing;
    }

    public void calculatePercentages(int space, int positionCount) {
        if (this.percentageSizing) {
            this.availableSpace = space;
            int sum = 0;
            int real = 0;
            int realSum = 0;
            ArrayList<Integer> noInfoPositions = new ArrayList<Integer>();
            Integer positionValue = null;
            int i = 0;
            while (i < positionCount) {
                positionValue = this.sizeMap.get(i);
                if (positionValue != null) {
                    sum += positionValue.intValue();
                    real = this.calculatePercentageValue(positionValue, space);
                    realSum += real;
                    this.realSizeMap.put(i, real);
                } else {
                    noInfoPositions.add(i);
                }
                ++i;
            }
            if (!noInfoPositions.isEmpty()) {
                double remaining = new Double(space) - (double)realSum;
                Double remainingColSpace = remaining / (double)noInfoPositions.size();
                for (Integer position : noInfoPositions) {
                    sum = (int)((double)sum + remainingColSpace / (double)space * 100.0);
                    this.realSizeMap.put(position, remainingColSpace.intValue());
                }
                sum = 100;
            }
            if (sum == 100) {
                int valueSum = 0;
                int lastPos = -1;
                for (Map.Entry<Integer, Integer> entry : this.realSizeMap.entrySet()) {
                    valueSum += entry.getValue().intValue();
                    lastPos = Math.max(lastPos, entry.getKey());
                }
                if (valueSum < space) {
                    int lastPosValue = this.realSizeMap.get(lastPos);
                    this.realSizeMap.put(lastPos, lastPosValue + (space - valueSum));
                }
            }
        }
    }

    private int calculatePercentageValue(int percentage, int space) {
        double factor = (double)percentage / 100.0;
        return new Double((double)space * factor).intValue();
    }
}

