/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.hideshow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.nebula.widgets.nattable.hideshow.AbstractColumnHideShowLayer;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ColumnHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnHideCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.MultiColumnShowCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.command.ShowAllColumnsCommandHandler;
import org.eclipse.nebula.widgets.nattable.hideshow.event.HideColumnPositionsEvent;
import org.eclipse.nebula.widgets.nattable.hideshow.event.ShowColumnPositionsEvent;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;

public class ColumnHideShowLayer
extends AbstractColumnHideShowLayer {
    public static final String PERSISTENCE_KEY_HIDDEN_COLUMN_INDEXES = ".hiddenColumnIndexes";
    private final Set<Integer> hiddenColumnIndexes = new TreeSet<Integer>();

    public ColumnHideShowLayer(IUniqueIndexLayer underlyingLayer) {
        super(underlyingLayer);
        this.registerCommandHandler(new MultiColumnHideCommandHandler(this));
        this.registerCommandHandler(new ColumnHideCommandHandler(this));
        this.registerCommandHandler(new ShowAllColumnsCommandHandler(this));
        this.registerCommandHandler(new MultiColumnShowCommandHandler(this));
    }

    @Override
    public void saveState(String prefix, Properties properties) {
        if (this.hiddenColumnIndexes.size() > 0) {
            StringBuilder strBuilder = new StringBuilder();
            for (Integer index : this.hiddenColumnIndexes) {
                strBuilder.append(index);
                strBuilder.append(",");
            }
            properties.setProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_COLUMN_INDEXES, strBuilder.toString());
        }
        super.saveState(prefix, properties);
    }

    @Override
    public void loadState(String prefix, Properties properties) {
        this.hiddenColumnIndexes.clear();
        String property = properties.getProperty(String.valueOf(prefix) + PERSISTENCE_KEY_HIDDEN_COLUMN_INDEXES);
        if (property != null) {
            StringTokenizer tok = new StringTokenizer(property, ",");
            while (tok.hasMoreTokens()) {
                String index = tok.nextToken();
                this.hiddenColumnIndexes.add(Integer.valueOf(index));
            }
        }
        super.loadState(prefix, properties);
    }

    @Override
    public boolean isColumnIndexHidden(int columnIndex) {
        return this.hiddenColumnIndexes.contains(columnIndex);
    }

    @Override
    public Collection<Integer> getHiddenColumnIndexes() {
        return this.hiddenColumnIndexes;
    }

    public void hideColumnPositions(Collection<Integer> columnPositions) {
        HashSet<Integer> columnIndexes = new HashSet<Integer>();
        for (Integer columnPosition : columnPositions) {
            columnIndexes.add(this.getColumnIndexByPosition(columnPosition));
        }
        TreeSet<Integer> backup = new TreeSet<Integer>(this.hiddenColumnIndexes);
        this.hiddenColumnIndexes.addAll(columnIndexes);
        this.invalidateCache();
        if (this.getColumnCount() == 0) {
            this.hiddenColumnIndexes.clear();
            this.hiddenColumnIndexes.addAll(backup);
            this.invalidateCache();
            return;
        }
        this.fireLayerEvent(new HideColumnPositionsEvent((ILayer)this, columnPositions));
    }

    public void showColumnIndexes(Collection<Integer> columnIndexes) {
        this.hiddenColumnIndexes.removeAll(columnIndexes);
        this.invalidateCache();
        this.fireLayerEvent(new ShowColumnPositionsEvent(this, this.getColumnPositionsByIndexes(columnIndexes)));
    }

    public void showAllColumns() {
        ArrayList<Integer> hiddenColumns = new ArrayList<Integer>(this.hiddenColumnIndexes);
        this.hiddenColumnIndexes.clear();
        this.invalidateCache();
        this.fireLayerEvent(new ShowColumnPositionsEvent(this, hiddenColumns));
    }
}

