/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.group.painter;

import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.group.ColumnGroupModel;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.painter.cell.CellPainterWrapper;
import org.eclipse.nebula.widgets.nattable.painter.cell.ICellPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.ImagePainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.TextPainter;
import org.eclipse.nebula.widgets.nattable.painter.cell.decorator.CellPainterDecorator;
import org.eclipse.nebula.widgets.nattable.ui.util.CellEdgeEnum;
import org.eclipse.nebula.widgets.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class ColumnGroupHeaderTextPainter
extends CellPainterWrapper {
    private final ColumnGroupModel columnGroupModel;

    public ColumnGroupHeaderTextPainter(ColumnGroupModel columnGroupModel) {
        this.columnGroupModel = columnGroupModel;
        this.setWrappedPainter(new CellPainterDecorator(new TextPainter(), CellEdgeEnum.RIGHT, new ExpandCollapseImagePainter()));
    }

    public ColumnGroupHeaderTextPainter(ColumnGroupModel columnGroupModel, ICellPainter interiorPainter) {
        this.columnGroupModel = columnGroupModel;
        this.setWrappedPainter(new CellPainterDecorator(interiorPainter, CellEdgeEnum.RIGHT, new ExpandCollapseImagePainter()));
    }

    @Override
    public int getPreferredWidth(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return 0;
    }

    @Override
    public int getPreferredHeight(ILayerCell cell, GC gc, IConfigRegistry configRegistry) {
        return 25;
    }

    private class ExpandCollapseImagePainter
    extends ImagePainter {
        final Image rightImg = GUIHelper.getImage("right");
        final Image leftImg = GUIHelper.getImage("left");

        private ExpandCollapseImagePainter() {
        }

        @Override
        protected Image getImage(ILayerCell cell, IConfigRegistry configRegistry) {
            Object dataValue = cell.getDataValue();
            if (dataValue != null) {
                String cellValue = dataValue.toString();
                ColumnGroupModel.ColumnGroup columnGroup = ColumnGroupHeaderTextPainter.this.columnGroupModel.getColumnGroupByName(cellValue);
                if (columnGroup != null && columnGroup.isCollapseable()) {
                    return columnGroup.isCollapsed() ? this.rightImg : this.leftImg;
                }
            }
            return null;
        }
    }
}

